/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.oss.jarjar.org.apache.commons.codec.binary.Hex;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class TOHHCODE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean tostring;
    private final boolean useGtsConvention;

    public TOHHCODE(String name, boolean tostring) {
        this(name, tostring, false);
    }

    public TOHHCODE(String name, boolean tostring, boolean useGtsConvention) {
        super(name);
        this.tostring = tostring;
        this.useGtsConvention = useGtsConvention;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long geoxppoint;
        Object lon = stack.pop();
        Object lat = stack.pop();
        if (!(lon instanceof Number) || !(lat instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a latitude and a longitude on the stack.");
        }
        double latDouble = ((Number)lat).doubleValue();
        double lonDouble = ((Number)lon).doubleValue();
        if (this.useGtsConvention) {
            if (Double.isNaN(latDouble) != Double.isNaN(lonDouble)) {
                throw new WarpScriptException(this.getName() + " expects latitude and longitude to both be NaN or both be not NaN");
            }
            geoxppoint = !Double.isNaN(latDouble) ? GeoXPLib.toGeoXPPoint((double)latDouble, (double)lonDouble) : 91480763316633925L;
        } else {
            geoxppoint = GeoXPLib.toGeoXPPoint((double)latDouble, (double)lonDouble);
        }
        if (this.tostring) {
            String hhcode = Hex.encodeHexString((byte[])Longs.toByteArray((long)geoxppoint));
            stack.push(hhcode);
        } else {
            stack.push(geoxppoint);
        }
        return stack;
    }
}

