/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import io.warp10.script.functions.GET;
import io.warp10.script.functions.shape.CHECKSHAPE;
import io.warp10.script.functions.shape.SHAPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PERMUTE
extends FormattedWarpScriptFunction {
    public static final String TENSOR = "tensor";
    public static final String PATTERN = "pattern";
    public static final String FAST = "fast";
    private final FormattedWarpScriptFunction.Arguments args;
    private final FormattedWarpScriptFunction.Arguments output;

    @Override
    protected FormattedWarpScriptFunction.Arguments getArguments() {
        return this.args;
    }

    protected FormattedWarpScriptFunction.Arguments getOutput() {
        return this.output;
    }

    public PERMUTE(String name) {
        super(name);
        this.getDocstring().append("Permute the dimensions of a nested LIST as if it were a tensor or a multidimensional array.");
        this.args = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(List.class, TENSOR, "The nested LIST for which dimensions will be permuted as if it were a tensor.").addListArgument(Long.class, PATTERN, "The permutation pattern (a LIST of LONG).").addOptionalArgument(Boolean.class, FAST, "If true, it does not check if the sizes of the nested lists are coherent before operating. Default to false.", false).build();
        this.output = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(List.class, TENSOR, "The resulting nested LIST.").build();
    }

    @Override
    protected WarpScriptStack apply(Map<String, Object> formattedArgs, WarpScriptStack stack) throws WarpScriptException {
        List tensor = (List)formattedArgs.get(TENSOR);
        List pattern = (List)formattedArgs.get(PATTERN);
        boolean fast = Boolean.TRUE.equals(formattedArgs.get(FAST));
        if (pattern.size() > new HashSet(pattern).size()) {
            throw new WarpScriptException(this.getName() + " error: duplicate axis in permutation pattern.");
        }
        List<Long> shape = SHAPE.candidate_shape(tensor);
        if (!fast && !CHECKSHAPE.recValidateShape(tensor, shape).booleanValue()) {
            throw new WarpScriptException(this.getName() + " expects that the sizes of the nested lists are coherent together to form a tensor (or multidimensional array).");
        }
        ArrayList<Long> newShape = new ArrayList<Long>();
        for (int r = 0; r < pattern.size(); ++r) {
            newShape.add(shape.get(((Long)pattern.get(r)).intValue()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.recPermute(tensor, result, new ArrayList<Long>(), 0, pattern, newShape);
        stack.push(result);
        return stack;
    }

    private void recPermute(List<Object> tensor, List<Object> result, List<Long> indices, int dimension, List<Long> pattern, List<Long> newShape) throws WarpScriptException {
        int i = 0;
        while ((long)i < newShape.get(dimension)) {
            ArrayList<Long> new_indices = new ArrayList<Long>(indices);
            new_indices.add(new Long(i));
            if (newShape.size() - 1 == dimension) {
                ArrayList<Long> permutedIndices = new ArrayList<Long>();
                for (int r = 0; r < pattern.size(); ++r) {
                    permutedIndices.add((Long)new_indices.get(pattern.lastIndexOf(new Long(r))));
                }
                result.add(GET.nestedGet(tensor, permutedIndices));
            } else {
                ArrayList<Object> nested = new ArrayList<Object>();
                result.add(nested);
                this.recPermute(tensor, nested, new_indices, dimension + 1, pattern, newShape);
            }
            ++i;
        }
    }
}

