/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Map;

public class MapperExp
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    private double dvalue;

    public MapperExp(String name, Object value) throws WarpScriptException {
        super(name);
        if (value instanceof Long) {
            this.dvalue = ((Long)value).longValue();
        } else if (value instanceof Double) {
            this.dvalue = (Double)value;
        } else {
            throw new WarpScriptException("Invalid value type for " + this.getName());
        }
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        String[] names = (String[])args[1];
        Map[] labels = (Map[])args[2];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        Double value = null;
        long location = locations[0];
        long elevation = elevations[0];
        if (values[0] instanceof Long) {
            value = Math.pow(this.dvalue, ((Long)values[0]).longValue());
        } else if (values[0] instanceof Double) {
            value = Math.pow(this.dvalue, (Double)values[0]);
        } else {
            throw new WarpScriptException(this.getName() + " can only be applied to LONG or DOUBLE values.");
        }
        return new Object[]{tick, location, elevation, value};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.dvalue));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Long) && !(value instanceof Double)) {
                throw new WarpScriptException("Invalid parameter for " + this.getName());
            }
            stack.push(new MapperExp(this.getName(), value));
            return stack;
        }
    }
}

