/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class MapperGeoApproximate
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    private final int resolution;

    public MapperGeoApproximate(String name, int resolution) throws WarpScriptException {
        super(name);
        if (resolution < 2 || resolution > 32 || 0 != (resolution & 1)) {
            throw new WarpScriptException(this.getName() + " expects an even resolution between 2 (coarsest) and 32 (finest).");
        }
        this.resolution = resolution;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        long location = locations[0];
        long elevation = elevations[0];
        if (values.length < 1 || 91480763316633925L == location) {
            return new Object[]{tick, location, elevation, null};
        }
        location = GeoXPLib.centerGeoXPPoint((long)location, (int)this.resolution);
        return new Object[]{tick, location, elevation, values[0]};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.resolution);
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects an even resolution between 2 (coarsest) and 32 (finest).");
            }
            int resolution = ((Number)o).intValue();
            stack.push(new MapperGeoApproximate(this.getName(), resolution));
            return stack;
        }
    }
}

