/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;

public class MapperKernelSmoother
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    private final long step;
    private final long width;
    private final double[] weights;

    public MapperKernelSmoother(String name, long step, long width, double[] weights) {
        super(name);
        this.step = step;
        this.width = width;
        this.weights = weights;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        double weightedValue = 0.0;
        double weightedLatitude = 0.0;
        double weightedLongitude = 0.0;
        double weightedElevation = 0.0;
        double valueDividend = 0.0;
        double locationDividend = 0.0;
        double elevationDividend = 0.0;
        for (int i = 0; i < ticks.length; ++i) {
            int idx = (int)(Math.abs(ticks[i] - tick) / this.step);
            if (idx >= this.weights.length || !(values[i] instanceof Number)) continue;
            weightedValue += this.weights[idx] * ((Number)values[i]).doubleValue();
            valueDividend += this.weights[idx];
            if (91480763316633925L != locations[i]) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)locations[i]);
                weightedLatitude += this.weights[idx] * latlon[0];
                weightedLongitude += this.weights[idx] * latlon[1];
                locationDividend += this.weights[idx];
            }
            if (Long.MIN_VALUE == elevations[i]) continue;
            weightedElevation += this.weights[idx] * (double)elevations[i];
            elevationDividend += this.weights[idx];
        }
        long elevation = Long.MIN_VALUE;
        long location = 91480763316633925L;
        Double value = null;
        if (0.0 != valueDividend) {
            value = weightedValue / valueDividend;
            if (0.0 != elevationDividend) {
                elevation = (long)(weightedElevation / elevationDividend);
            }
            if (0.0 != locationDividend) {
                location = GeoXPLib.toGeoXPPoint((double)(weightedLatitude / locationDividend), (double)(weightedLongitude / locationDividend));
            }
        }
        return new Object[]{tick, location, elevation, value};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.step));
        sb.append(" ");
        sb.append(StackUtils.toString(this.width));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }
}

