/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Map;

public class MapperMod
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    private GeoTimeSerie.TYPE type = GeoTimeSerie.TYPE.UNDEFINED;
    private long lvalue;
    private double dvalue;

    public MapperMod(String name, Object value) throws WarpScriptException {
        super(name);
        if (value instanceof Long) {
            this.type = GeoTimeSerie.TYPE.LONG;
        } else if (value instanceof Double) {
            this.type = GeoTimeSerie.TYPE.DOUBLE;
        } else {
            throw new WarpScriptException("Invalid value type for " + this.getName());
        }
        this.lvalue = ((Number)value).longValue();
        this.dvalue = ((Number)value).doubleValue();
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        String[] names = (String[])args[1];
        Map[] labels = (Map[])args[2];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        Number value = null;
        long location = locations[0];
        long elevation = elevations[0];
        if (!(values[0] instanceof Double) && !(values[0] instanceof Long)) {
            throw new WarpScriptException(this.getName() + " can only be applied to LONG or DOUBLE values.");
        }
        value = GeoTimeSerie.TYPE.LONG.equals((Object)this.type) ? (Number)(values[0] instanceof Long ? (Number)(((Number)values[0]).longValue() % this.lvalue) : (Number)(((Number)values[0]).doubleValue() % (double)this.lvalue)) : (Number)(((Number)values[0]).doubleValue() % this.dvalue);
        return new Object[]{tick, location, elevation, value};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (GeoTimeSerie.TYPE.LONG == this.type) {
            sb.append(StackUtils.toString(this.lvalue));
        } else {
            sb.append(StackUtils.toString(this.dvalue));
        }
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Long) && !(value instanceof Double)) {
                throw new WarpScriptException("Invalid parameter for " + this.getName());
            }
            stack.push(new MapperMod(this.getName(), value));
            return stack;
        }
    }
}

