/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.joda.time.DateTimeZone;

public class MapperReplace
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    public final Object value;
    private final DateTimeZone dtz;

    public MapperReplace(String name, Object value) throws WarpScriptException {
        super(name);
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            this.value = ((Number)value).longValue();
        } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            this.value = ((Number)value).doubleValue();
        } else if (value instanceof Boolean) {
            this.value = value;
        } else if (value instanceof String) {
            this.value = value;
        } else {
            throw new WarpScriptException("Invalid value type.");
        }
        this.dtz = DateTimeZone.UTC;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, null};
        }
        return new Object[]{tick, locations[0], elevations[0], this.value};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.value));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            stack.push(new MapperReplace(this.getName(), value));
            return stack;
        }
    }
}

