/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import org.apache.commons.codec.binary.Base64;
import processing.core.PGraphics;

public class Pencode
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public Pencode(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof PGraphics)) {
            throw new WarpScriptException(this.getName() + " operates on a PGraphics instance.");
        }
        PGraphics pg = (PGraphics)top;
        pg.endDraw();
        BufferedImage bimage = new BufferedImage(pg.pixelWidth, pg.pixelHeight, 2);
        bimage.setRGB(0, 0, pg.pixelWidth, pg.pixelHeight, pg.pixels, 0, pg.pixelWidth);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = null;
        if (iter.hasNext()) {
            writer = iter.next();
        }
        ImageWriteParam param = writer.getDefaultWriteParam();
        IIOMetadata metadata = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream output = new BufferedOutputStream(baos);
        try {
            writer.setOutput(ImageIO.createImageOutputStream(output));
            writer.write(metadata, new IIOImage(bimage, null, metadata), param);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " error while encoding PGraphics.", ioe);
        }
        writer.dispose();
        StringBuilder sb = new StringBuilder("data:image/png;base64,");
        sb.append(Base64.encodeBase64String((byte[])baos.toByteArray()));
        stack.push(sb.toString());
        pg.beginDraw();
        return stack;
    }
}

