/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.rendering;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.awt.image.BufferedImage;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.opengl.PGraphics3D;

public class PGraphics
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PGraphics(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long PIXEL_LIMIT;
        Object top = stack.pop();
        PGraphicsJava2D pg = null;
        if (String.valueOf(top).startsWith("2D")) {
            pg = new PGraphicsJava2D();
            if (!"2D".equals(top)) {
                pg.smooth(Integer.parseInt(String.valueOf(top).substring(2)));
            }
        } else {
            if (!String.valueOf(top).startsWith("3D")) throw new WarpScriptException(this.getName() + " expects a type ('2D' or '3D') on top of the stack.");
            try {
                pg = new PGraphics3D();
                if (!"3D".equals(top)) {
                    pg.smooth(Integer.parseInt(String.valueOf(top).substring(2)));
                }
            }
            catch (Throwable t) {
                throw new WarpScriptException(this.getName() + " unable to create 3D container.", t);
            }
        }
        if (!((top = stack.pop()) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a height in pixels below the type.");
        }
        int height = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a width in pixels below the height.");
        }
        int width = ((Number)top).intValue();
        if ((long)(width * height) > (PIXEL_LIMIT = ((Long)stack.getAttribute("stack.maxpixels")).longValue())) {
            throw new WarpScriptException(this.getName() + " only allows graphics with a total number of pixels less than " + PIXEL_LIMIT);
        }
        pg.hint(12);
        PApplet pa = new PApplet();
        pa.g = pg;
        pg.parent = pa;
        pg.setSize(width, height);
        pg.setPrimary(false);
        pg.image = new BufferedImage(pg.pixelWidth, pg.pixelHeight, 2);
        pg.beginDraw();
        pg.parent.loadPixels();
        pg.parent.colorMode(1, 255.0f, 255.0f, 255.0f, 255.0f);
        stack.push(pg);
        return stack;
    }
}

