/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.typography;

import io.warp10.WarpConfig;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.processing.ProcessingUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import processing.core.PFont;
import processing.core.PGraphics;

public class PcreateFont
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final FontResolver resolver = new FontResolver(WarpConfig.getProperty("processing.font.resolver"));

    public PcreateFont(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        List<Object> params = ProcessingUtil.parseParams(stack, 2, 3, 4);
        PGraphics pg = (PGraphics)params.get(0);
        PFont font = null;
        if (params.get(1).toString().startsWith("http://") || params.get(1).toString().startsWith("https://") || params.get(1).toString().startsWith("file://")) {
            String urlstr = this.resolver.resolve(params.get(1).toString());
            InputStream in = null;
            try {
                URL url = new URL(urlstr);
                URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                in = new URL(uri.toASCIIString()).openStream();
                Font f = Font.createFont(0, in);
                float size = 12.0f;
                boolean smooth = true;
                char[] charset = null;
                if (params.size() >= 3) {
                    size = ((Number)params.get(2)).floatValue();
                }
                if (params.size() >= 4) {
                    smooth = Boolean.TRUE.equals(params.get(3));
                }
                if (params.size() >= 5) {
                    charset = params.get(4).toString().toCharArray();
                }
                font = new PFont(f.deriveFont(size * (float)pg.parent.pixelDensity), smooth, charset, true, pg.parent.pixelDensity);
            }
            catch (URISyntaxException use) {
                throw new WarpScriptException(this.getName() + " error loading font " + urlstr, use);
            }
            catch (FontFormatException ffe) {
                throw new WarpScriptException(this.getName() + " error loading font " + urlstr, ffe);
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error fetching font " + urlstr, ioe);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (3 == params.size()) {
            font = pg.parent.createFont(params.get(1).toString(), ((Number)params.get(2)).floatValue());
        } else if (4 == params.size()) {
            font = pg.parent.createFont(params.get(1).toString(), ((Number)params.get(2)).floatValue(), Boolean.TRUE.equals(params.get(3)));
        } else if (5 == params.size()) {
            font = pg.parent.createFont(params.get(1).toString(), ((Number)params.get(2)).floatValue(), Boolean.TRUE.equals(params.get(3)), params.get(4).toString().toCharArray());
        }
        stack.push(pg);
        stack.push(font);
        return stack;
    }

    private static class FontResolver {
        private final String warpscript;

        public FontResolver(String mc2) {
            this.warpscript = mc2;
        }

        public String resolve(String url) throws WarpScriptException {
            if (null == this.warpscript) {
                throw new WarpScriptException("Font resolver not set, rejecting all URLs.");
            }
            try {
                MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
                stack.push(url);
                stack.exec(this.warpscript);
                return (String)stack.pop();
            }
            catch (Exception e) {
                throw new WarpScriptException("Error resolving URL.", e);
            }
        }
    }
}

