/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.unary;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;

public class FROMBITS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean asFloat;

    public FROMBITS(String name, boolean asFloat) {
        super(name);
        this.asFloat = asFloat;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op = stack.pop();
        if (!(op instanceof Long) && !(op instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " operates on a LONG or a Geo Time Series thereof.");
        }
        if (op instanceof GeoTimeSerie && GeoTimeSerie.TYPE.LONG != ((GeoTimeSerie)op).getType()) {
            throw new WarpScriptException(this.getName() + " operates on a LONG Geo Time Series.");
        }
        if (op instanceof Long) {
            if (this.asFloat) {
                stack.push(Float.intBitsToFloat((int)((Long)op & 0xFFFFFFFFL)));
            } else {
                stack.push(Double.longBitsToDouble((Long)op));
            }
        } else {
            GeoTimeSerie gts = (GeoTimeSerie)op;
            GTSEncoder encoder = new GTSEncoder(0L);
            encoder.setMetadata(new Metadata(gts.getMetadata()));
            int n = gts.size();
            try {
                for (int i = 0; i < n; ++i) {
                    double value = this.asFloat ? (double)Float.intBitsToFloat((int)(((Number)GTSHelper.valueAtIndex(gts, i)).longValue() & 0xFFFFFFFFL)) : Double.longBitsToDouble(((Number)GTSHelper.valueAtIndex(gts, i)).longValue());
                    encoder.addValue(GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value);
                }
            }
            catch (IOException ioe) {
                throw new WarpScriptException(ioe);
            }
            stack.push(encoder.getDecoder(true).decode());
        }
        return stack;
    }
}

