/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warp.sdk;

import io.warp10.WarpClassLoader;
import io.warp10.WarpConfig;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.StoreClient;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWarp10Plugin {
    private static Logger LOG = LoggerFactory.getLogger(AbstractWarp10Plugin.class);
    private static final AtomicBoolean registered = new AtomicBoolean(false);
    private static final List<String> plugins = new ArrayList<String>();

    public abstract void init(Properties var1);

    /*
     * WARNING - void declaration
     */
    public static final void registerPlugins() {
        if (registered.get()) {
            return;
        }
        registered.set(true);
        Properties props = WarpConfig.getProperties();
        HashSet<String> plugs = new HashSet<String>();
        if (null != props && props.containsKey("warp10.plugins")) {
            String[] plugins;
            for (String plugin : plugins = props.getProperty("warp10.plugins").split(",")) {
                plugs.add(plugin.trim());
            }
        }
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith("warp10.plugin.")) continue;
            plugs.add(props.getProperty(key).trim());
        }
        if (plugs.isEmpty()) {
            return;
        }
        boolean failedPlugin = false;
        ArrayList<void> failed = new ArrayList<void>();
        ArrayList sorted = new ArrayList(plugs);
        sorted.sort(null);
        String wsljar = null;
        URL wslurl = AbstractWarp10Plugin.class.getResource('/' + AbstractWarp10Plugin.class.getCanonicalName().replace('.', '/') + ".class");
        if (null != wslurl && "jar".equals(wslurl.getProtocol())) {
            wsljar = wslurl.toString().replaceAll("!/.*", "").replaceAll("jar:file:", "");
        }
        for (String string : sorted) {
            try {
                void var8_11;
                URL url;
                if (string.contains("#")) {
                    String string2 = string.replaceAll("^.*#", "");
                }
                if (null == (url = AbstractWarp10Plugin.class.getResource('/' + var8_11.replace('.', '/') + ".class"))) {
                    LOG.error("Unable to load plugin '" + (String)var8_11 + "', make sure it is in the class path.");
                    failedPlugin = true;
                    failed.add(var8_11);
                    continue;
                }
                Class<?> cls = null;
                if ("jar".equals(url.getProtocol())) {
                    String jarfile = url.toString().replaceAll("!/.*", "").replaceAll("jar:file:", "");
                    ClassLoader cl = AbstractWarp10Plugin.class.getClassLoader();
                    if (!jarfile.equals(wsljar)) {
                        cl = new WarpClassLoader(jarfile, AbstractWarp10Plugin.class.getClassLoader());
                    }
                    cls = Class.forName((String)var8_11, true, cl);
                } else {
                    cls = Class.forName((String)var8_11, true, AbstractWarp10Plugin.class.getClassLoader());
                }
                AbstractWarp10Plugin wse = (AbstractWarp10Plugin)cls.newInstance();
                wse.init(WarpConfig.getProperties());
                LOG.info("LOADED plugin '" + (String)var8_11 + "'");
                plugins.add((String)var8_11);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (failedPlugin) {
            throw new RuntimeException("Some WarpScript plugins could not be loaded, aborting. " + ((Object)failed).toString());
        }
    }

    public static final StoreClient getExposedStoreClient() {
        try {
            Class<?> egress = Class.forName("io.warp10.continuum.egress.EgressExecHandler");
            Method m = egress.getDeclaredMethod("getExposedStoreClient", new Class[0]);
            return (StoreClient)m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            LOG.warn("Unable to retrieve StoreClient", t);
            return null;
        }
    }

    public static final DirectoryClient getExposedDirectoryClient() {
        try {
            Class<?> egress = Class.forName("io.warp10.continuum.egress.EgressExecHandler");
            Method m = egress.getDeclaredMethod("getExposedDirectoryClient", new Class[0]);
            return (DirectoryClient)m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            LOG.warn("Unable to retrieve DirectoryClient", t);
            return null;
        }
    }

    public static final List<String> plugins() {
        return new ArrayList<String>(plugins);
    }
}

