/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision;

import io.warp10.sensision.SensisionMetricsDumper;
import io.warp10.sensision.SensisionMetricsServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sensision {
    private static final String uuid = UUID.randomUUID().toString();
    private static long starttime = System.currentTimeMillis();
    private static List<Iterable<Value>> providers = new ArrayList<Iterable<Value>>();
    public static final String SENSISION_DISABLE = "sensision.disable";
    public static final String SENSISION_TIME_UNIT = "sensision.timeunit";
    public static final String SENSISION_INSTANCE = "sensision.instance";
    public static final String SENSISION_QUEUEMANAGER = "sensision.queuemanager";
    public static final String SENSISION_POLLERS = "sensision.pollers";
    public static final String SENSISION_HTTP_TOKEN_HEADER_DEFAULT = "X-Warp10-Token";
    public static final String HTTP_HEADER_UUID = "X-UUID";
    public static final String HTTP_HEADER_TIMESTAMP = "X-Timestamp";
    public static final String HTTP_HEADER_LASTEVENT = "X-Sensision-LastEvent";
    public static final String DEFAULT_SENSISION_HOME = "/var/run/sensision";
    private static final String SENSISION_TARGETS_SUBDIR = "targets";
    public static final String SENSISION_TARGETS_SUFFIX = ".target";
    public static final Pattern SENSISION_TARGET_PATTERN = Pattern.compile("^([0-9a-f]+)\\.([0-9]+)\\.([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\\.([0-9]{1,5}).*$");
    public static final long DEFAULT_DUMP_PERIOD = 10000L;
    public static final String SENSISION_CONFIG_FILE = "sensision.config";
    private static final String SENSISION_QUEUE_SUBDIR = "queued";
    public static final String SENSISION_QUEUED_SUFFIX = ".queued";
    public static final String SENSISION_METRICS_SUBDIR = "metrics";
    public static final String SENSISION_METRICS_SUFFIX = ".metrics";
    public static final String SENSISION_HOME = "sensision.home";
    public static final String SENSISION_EVENTS_HISTORY = "sensision.events.history";
    public static final String SENSISION_EVENTS_SUFFIX = "sensision.events.suffix";
    public static final String SENSISION_EVENTS_DIR = "sensision.events.dir";
    public static final String DEFAULT_SENSISION_POLLING_HINT = "60000";
    public static final String DEFAULT_SENSISION_URLDEBUG = "false";
    public static final String SENSISION_STRING_OPTIMIZE = "sensision.string.optimize";
    public static final String SENSISION_HTTPPOLLER_SLEEP = "sensision.poller.http.sleep";
    public static final String SENSISION_HTTPPOLLER_SCANPERIOD = "sensision.poller.http.scanperiod";
    public static final String SENSISION_HTTPPOLLER_FORCEDHINT = "sensision.poller.http.forcedhint";
    public static final String SENSISION_SCRIPTRUNNER = "sensision.scriptrunner";
    public static final String SENSISION_SCRIPTRUNNER_ROOT = "sensision.scriptrunner.root";
    public static final String SENSISION_SCRIPTRUNNER_NTHREADS = "sensision.scriptrunner.nthreads";
    public static final String SENSISION_SCRIPTRUNNER_SCANPERIOD = "sensision.scriptrunner.scanperiod";
    public static final String SENSISION_JMX_POLLER = "sensision.jmx.poller";
    public static final String SENSISION_POLLING_HINT = "sensision.polling.hint";
    public static final String SENSISION_POLLING_PERIOD = "sensision.polling.period";
    public static final String SENSISION_DUMP_PERIOD = "sensision.dump.period";
    public static final String SENSISION_DUMP_CURRENTTS = "sensision.dump.currentts";
    public static final String SENSISION_DUMP_ONEXIT = "sensision.dump.onexit";
    public static final String SENSISION_CURATION_PERIOD = "sensision.curation.period";
    public static final String SENSISION_SERVER_PORT = "sensision.server.port";
    public static final String SENSISION_DEFAULT_LABELS = "sensision.default.labels";
    public static final String SENSISION_DEFAULT_LOCATION = "sensision.default.location";
    public static final String SENSISION_DEFAULT_ELEVATION = "sensision.default.elevation";
    public static final String SENSISION_HTTP_NOKEEPALIVE = "sensision.http.nokeepalive";
    public static final String SENSISION_URLDEBUG = "sensision.urldebug";
    static Map<String, String> defaultLabels = new HashMap<String, String>();
    static Double defaultLatitude = null;
    static Double defaultLongitude = null;
    static Long defaultElevation = null;
    public static Map<String, String> EMPTY_LABELS = Collections.unmodifiableMap(new HashMap());
    static boolean disable = false;
    static boolean useStringIntern = false;
    public static long TIME_UNITS_PER_MS = 1000L;
    private static final SensisionMetricsServer server;
    private static final SensisionMetricsDumper dumper;
    private static final MetricsCurator curator;
    private static final AtomicLong eventSequence;
    private static final String[] events;
    private static final String eventsDir;
    private static File eventsFile;
    private static PrintWriter eventsWriter;
    private static final String eventsSuffix;
    private static String instanceName;
    private static Map<String, Map<Map<String, String>, Value>> values;
    private static final Pattern MEASUREMENT_RE;
    private static final Pattern STRING_VALUE_RE;
    private static final Pattern BOOLEAN_VALUE_RE;
    private static final Pattern LONG_VALUE_RE;
    private static final Pattern DOUBLE_VALUE_RE;

    public static final synchronized void set(String cls, Map<String, String> labels, long ts, Float latitude, Float longitude, Long elevation, Object value, Long ttl) {
        if (disable) {
            return;
        }
        if (null == cls) {
            throw new RuntimeException("Invalid null class name for metric");
        }
        if (labels.containsKey(null) || labels.containsValue(null)) {
            throw new RuntimeException("Invalid null label for metric " + cls + labels);
        }
        Value container = Sensision.getContainer(cls, labels, value);
        if (null == container) {
            return;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            if (null != container.type && Value.TYPE.LONG != container.type) {
                throw new RuntimeException("Invalid value type for " + cls + labels + ", was " + (Object)((Object)container.type) + ", is now LONG");
            }
            if (null == container.value) {
                container.type = Value.TYPE.LONG;
                container.value = new AtomicLong(((Number)value).longValue());
            } else {
                ((AtomicLong)container.value).set(((Number)value).longValue());
            }
        } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            if (null != container.type && Value.TYPE.DOUBLE != container.type) {
                throw new RuntimeException("Invalid value type for " + cls + labels + ", was " + (Object)((Object)container.type) + ", is now DOUBLE");
            }
            if (null == container.value) {
                container.type = Value.TYPE.DOUBLE;
                container.value = new AtomicLong(Double.doubleToRawLongBits(((Number)value).doubleValue()));
            } else {
                ((AtomicLong)container.value).set(Double.doubleToRawLongBits(((Number)value).doubleValue()));
            }
        } else if (value instanceof Boolean) {
            if (null != container.type && Value.TYPE.BOOLEAN != container.type) {
                throw new RuntimeException("Invalid value type for " + cls + labels + ", was " + (Object)((Object)container.type) + ", is now BOOLEAN");
            }
            if (null == container.value) {
                container.type = Value.TYPE.BOOLEAN;
            }
            container.value = (Boolean)value;
        } else if (value instanceof String) {
            if (null != container.type && Value.TYPE.STRING != container.type) {
                throw new RuntimeException("Invalid value type for " + cls + labels + ", was " + (Object)((Object)container.type) + ", is now STRING");
            }
            if (null == container.value) {
                container.type = Value.TYPE.STRING;
            }
            container.value = (String)value;
        } else {
            throw new RuntimeException("Invalid value type (" + value.getClass() + ") for metric " + cls + labels);
        }
        container.latitude = latitude;
        container.longitude = longitude;
        container.elevation = elevation;
        container.timestamp = ts;
        if (null != ttl) {
            container.expire = System.currentTimeMillis() + ttl;
        }
    }

    private static Map<String, String> labelsToMap(String ... labels) {
        HashMap<String, String> labelsmap = new HashMap<String, String>();
        if (null != labels) {
            for (int i = 0; i < labels.length / 2; ++i) {
                labelsmap.put(labels[i * 2], labels[i * 2 + 1]);
            }
        }
        return labelsmap;
    }

    public static final void set(String cls, Map<String, String> labels, Object value) {
        Sensision.set(cls, labels, System.currentTimeMillis() * TIME_UNITS_PER_MS, null, null, null, value, null);
    }

    public static final void set(String cls, Map<String, String> labels, Object value, Long ttl) {
        Sensision.set(cls, labels, System.currentTimeMillis() * TIME_UNITS_PER_MS, null, null, null, value, ttl);
    }

    public static final void set(String cls, long ts, Float latitude, Float longitude, Long elevation, Object value, Long ttl, String ... labels) {
        Sensision.set(cls, Sensision.labelsToMap(labels), ts, latitude, longitude, elevation, value, ttl);
    }

    public static final void set(String cls, Object value, String ... labels) {
        Sensision.set(cls, Sensision.labelsToMap(labels), value);
    }

    public static final synchronized boolean clear(String cls, Map<String, String> labels) {
        Value container = Sensision.getContainer(cls, labels, null);
        return null != container;
    }

    public static final synchronized void update(String cls, Map<String, String> labels, long ts, Float latitude, Float longitude, Long elevation, Number delta, Long ttl) {
        if (disable) {
            return;
        }
        if (null == cls) {
            throw new RuntimeException("Invalid null class name for metric");
        }
        if (labels.containsKey(null) || labels.containsValue(null)) {
            throw new RuntimeException("Invalid null label for metric " + cls + labels);
        }
        Value container = Sensision.getContainer(cls, labels, delta);
        if (null == container) {
            return;
        }
        if (Value.TYPE.LONG == container.type) {
            ((AtomicLong)container.value).addAndGet(delta.longValue());
        } else if (Value.TYPE.DOUBLE == container.type) {
            ((AtomicLong)container.value).set(Double.doubleToRawLongBits(delta.doubleValue() + Double.longBitsToDouble(((AtomicLong)container.value).get())));
        } else if (null == container.type) {
            if (delta instanceof Long || delta instanceof Integer || delta instanceof Short || delta instanceof Byte || delta instanceof BigInteger) {
                container.type = Value.TYPE.LONG;
                container.value = new AtomicLong(delta.longValue());
            } else if (delta instanceof Double || delta instanceof Float || delta instanceof BigDecimal) {
                container.type = Value.TYPE.DOUBLE;
                container.value = new AtomicLong(Double.doubleToRawLongBits(delta.doubleValue()));
            }
        } else {
            throw new RuntimeException("Can only update metrics of type LONG or DOUBLE (" + cls + labels + ")");
        }
        container.latitude = latitude;
        container.longitude = longitude;
        container.elevation = elevation;
        container.timestamp = ts;
        if (null != ttl) {
            container.expire = System.currentTimeMillis() + ttl;
        }
    }

    public static final void update(String cls, Map<String, String> labels, Long ttl, Number delta) {
        Sensision.update(cls, labels, System.currentTimeMillis() * TIME_UNITS_PER_MS, null, null, null, delta, ttl);
    }

    public static final void update(String cls, Map<String, String> labels, Number delta) {
        Sensision.update(cls, labels, System.currentTimeMillis() * TIME_UNITS_PER_MS, null, null, null, delta, null);
    }

    public static final void update(String cls, long ts, Float latitude, Float longitude, Long elevation, Number delta, Long ttl, String ... labels) {
        Sensision.update(cls, Sensision.labelsToMap(labels), ts, latitude, longitude, elevation, delta, ttl);
    }

    public static final void update(String cls, Number delta, String ... labels) {
        Sensision.update(cls, Sensision.labelsToMap(labels), delta);
    }

    public static final void event(String cls, Map<String, String> labels, Object value) {
        Sensision.event(System.currentTimeMillis() * TIME_UNITS_PER_MS, Double.NaN, Double.NaN, null, cls, labels, value);
    }

    public static final void event(Long ts, Double latitude, Double longitude, Long elevation, String cls, Map<String, String> labels, Object value) {
        if ((0 == events.length || null == value) && null == eventsDir) {
            return;
        }
        long seqno = eventSequence.addAndGet(1L);
        StringBuilder sb = Sensision.buildEvent(ts, latitude, longitude, elevation, cls, labels, value);
        Sensision.storeEvent(sb);
        if (events.length > 0) {
            int idx = (int)(seqno % (long)events.length);
            Sensision.events[idx] = sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEvent(StringBuilder sb) {
        try {
            if (null == eventsDir) {
                return;
            }
            String string = eventsDir;
            synchronized (string) {
                File root = new File(eventsDir);
                if (!root.exists() || !root.isDirectory()) {
                    return;
                }
                if (null == eventsFile) {
                    String now = Long.toHexString(Long.MAX_VALUE - System.currentTimeMillis());
                    String uuid = UUID.randomUUID().toString();
                    eventsFile = new File(new File(eventsDir), now + "." + uuid + (null != eventsSuffix ? "." + eventsSuffix : ""));
                    try {
                        eventsWriter = new PrintWriter(eventsFile);
                    }
                    catch (FileNotFoundException fnfe) {
                        eventsFile = null;
                        return;
                    }
                }
                if (null != sb && null != eventsWriter) {
                    eventsWriter.println(sb.toString());
                }
            }
        }
        catch (Exception e) {
            if (null != eventsWriter) {
                eventsWriter.close();
                eventsFile = null;
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushEvents() {
        if (null == eventsDir) {
            return;
        }
        String string = eventsDir;
        synchronized (string) {
            if (null != eventsWriter) {
                eventsWriter.close();
                eventsFile.renameTo(new File(new File(eventsDir), eventsFile.getName() + SENSISION_METRICS_SUFFIX));
            }
            eventsFile = null;
            eventsWriter = null;
        }
    }

    public static boolean onDisk() {
        return null != eventsDir;
    }

    private static StringBuilder buildEvent(Long ts, Double latitude, Double longitude, Long elevation, String cls, Map<String, String> labels, Object value) {
        StringBuilder sb = new StringBuilder();
        if (null != ts) {
            sb.append(ts);
        } else {
            sb.append(System.currentTimeMillis() * TIME_UNITS_PER_MS);
        }
        sb.append("/");
        if (null != latitude && null != longitude && Double.isFinite(latitude) && Double.isFinite(longitude)) {
            sb.append(latitude);
            sb.append(":");
            sb.append(longitude);
        }
        sb.append("/");
        if (null != elevation) {
            sb.append(elevation);
        }
        sb.append(" ");
        Sensision.metadataToString(sb, cls, labels);
        sb.append(" ");
        if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                sb.append("T");
            } else {
                sb.append("F");
            }
        } else if (value instanceof String) {
            sb.append("'");
            Sensision.encodeName(sb, value.toString());
            sb.append("'");
        }
        return sb;
    }

    public static void encodeName(StringBuilder sb, String name) {
        if (null == name) {
            return;
        }
        try {
            sb.append(URLEncoder.encode(name, "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C").replaceAll("\\+", "%20"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void metadataToString(StringBuilder sb, String name, Map<String, String> labels) {
        Sensision.encodeName(sb, name);
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            Sensision.encodeName(sb, entry.getKey());
            sb.append("=");
            Sensision.encodeName(sb, entry.getValue());
            first = false;
        }
        sb.append("}");
    }

    public static final Object getValue(String cls, Map<String, String> labels) {
        Map<Map<String, String>, Value> clsValues = values.get(cls);
        if (null == clsValues) {
            return null;
        }
        Value container = clsValues.get(labels);
        if (null == container) {
            return null;
        }
        switch (container.type) {
            case BOOLEAN: {
                return container.value;
            }
            case LONG: {
                return ((AtomicLong)container.value).get();
            }
            case DOUBLE: {
                return Double.longBitsToDouble(((AtomicLong)container.value).get());
            }
            case STRING: {
                return container.value;
            }
        }
        return null;
    }

    public static final float[] getLocation(String cls, Map<String, String> labels) {
        Map<Map<String, String>, Value> clsValues = values.get(cls);
        if (null == clsValues) {
            return null;
        }
        Value container = clsValues.get(labels);
        if (null == container) {
            return null;
        }
        if (null == container.latitude || null == container.longitude) {
            return null;
        }
        float[] latlon = new float[]{container.latitude.floatValue(), container.longitude.floatValue()};
        return latlon;
    }

    public static final Long getElevation(String cls, Map<String, String> labels) {
        Map<Map<String, String>, Value> clsValues = values.get(cls);
        if (null == clsValues) {
            return null;
        }
        Value container = clsValues.get(labels);
        if (null == container) {
            return null;
        }
        return container.elevation;
    }

    public static final Long getTimestamp(String cls, Map<String, String> labels) {
        Map<Map<String, String>, Value> clsValues = values.get(cls);
        if (null == clsValues) {
            return null;
        }
        Value container = clsValues.get(labels);
        if (null == container) {
            return null;
        }
        return container.timestamp;
    }

    private static final synchronized Value getContainer(String cls, Map<String, String> labels, Object value) {
        Value container = null;
        Map<Map<String, String>, Value> clsValues = values.get(cls);
        if (null == value) {
            if (null != clsValues) {
                container = clsValues.remove(labels);
                if (0 == clsValues.size()) {
                    values.remove(cls);
                }
            }
        } else if (null == clsValues) {
            values.put(cls, new ConcurrentHashMap());
            container = new Value();
            HashMap<String, String> lbls = new HashMap<String, String>();
            if (!useStringIntern) {
                lbls.putAll(labels);
            } else {
                for (Map.Entry<String, String> entry : labels.entrySet()) {
                    lbls.put(entry.getKey().intern(), entry.getValue().intern());
                }
            }
            container.cls = cls;
            container.labels = lbls;
            values.get(cls).put(lbls, container);
        } else {
            container = clsValues.get(labels);
            if (null == container) {
                container = new Value();
                HashMap<String, String> lbls = new HashMap<String, String>();
                if (!useStringIntern) {
                    lbls.putAll(labels);
                } else {
                    for (Map.Entry<String, String> entry : labels.entrySet()) {
                        lbls.put(entry.getKey().intern(), entry.getValue().intern());
                    }
                }
                container.cls = cls;
                container.labels = lbls;
                values.get(cls).put(lbls, container);
            }
        }
        return container;
    }

    public static final Value parseMetric(String str) {
        String[] tokens;
        Matcher matcher = MEASUREMENT_RE.matcher(str);
        if (!matcher.matches()) {
            return null;
        }
        String name = matcher.group(6);
        if (name.contains("%")) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        TreeMap<String, String> labels = new TreeMap<String, String>();
        for (String token : tokens = matcher.group(7).split(",")) {
            String[] subtokens;
            if ("".equals(token) || (subtokens = token.split("=")).length > 2) continue;
            try {
                String lname = URLDecoder.decode(subtokens[0], "UTF-8");
                String lvalue = subtokens.length > 1 ? URLDecoder.decode(subtokens[1], "UTF-8") : "";
                labels.put(lname, lvalue);
            }
            catch (UnsupportedEncodingException lname) {
                // empty catch block
            }
        }
        Long timestamp = null;
        Float latitude = null;
        Float longitude = null;
        Long elevation = null;
        try {
            timestamp = null != matcher.group(1) ? Long.valueOf(matcher.group(1)) : Long.valueOf(Long.MIN_VALUE);
            if (null != matcher.group(2)) {
                latitude = Float.valueOf(matcher.group(3));
                longitude = Float.valueOf(matcher.group(4));
            }
            if (null != matcher.group(5)) {
                elevation = Long.valueOf(matcher.group(5));
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        String valuestr = matcher.group(8);
        Object value = Sensision.parseValue(valuestr);
        if (null == value) {
            return null;
        }
        Value v = new Value(name, labels, timestamp, latitude, longitude, elevation, value);
        return v;
    }

    public static Object parseValue(String valuestr) {
        Object value;
        Matcher valuematcher = DOUBLE_VALUE_RE.matcher(valuestr);
        if (valuematcher.matches()) {
            value = valuematcher.group(1).length() < 10 && valuematcher.group(2).length() < 10 && null == valuematcher.group(3) ? new BigDecimal(valuestr) : Double.valueOf(valuestr);
        } else {
            valuematcher = LONG_VALUE_RE.matcher(valuestr);
            if (valuematcher.matches()) {
                value = Long.valueOf(valuestr);
            } else {
                valuematcher = STRING_VALUE_RE.matcher(valuestr);
                if (valuematcher.matches()) {
                    value = valuestr.substring(1, valuestr.length() - 1);
                } else {
                    valuematcher = BOOLEAN_VALUE_RE.matcher(valuestr);
                    if (valuematcher.matches()) {
                        value = valuestr.startsWith("t") || valuestr.startsWith("T") ? Boolean.TRUE : Boolean.FALSE;
                    } else {
                        return null;
                    }
                }
            }
        }
        return value;
    }

    public static final void dump(PrintWriter out, boolean useValueTimestamp) throws IOException {
        for (Map<Map<String, String>, Value> map : values.values()) {
            for (Value value : map.values()) {
                Sensision.dumpValue(out, value, useValueTimestamp, true);
            }
        }
        for (Iterable iterable : providers) {
            Iterator iterator;
            if (null == iterable || null == (iterator = iterable.iterator())) continue;
            while (iterator.hasNext()) {
                Sensision.dumpValue(out, (Value)iterator.next(), useValueTimestamp, true);
            }
        }
    }

    public static final void dump(PrintWriter out) throws IOException {
        Sensision.dump(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dumpAsEvents(boolean useValueTimestamp) throws IOException {
        if (null == eventsDir) {
            return;
        }
        String string = eventsDir;
        synchronized (string) {
            Sensision.storeEvent(null);
            if (null != eventsWriter) {
                Sensision.dump(eventsWriter, useValueTimestamp);
            }
        }
    }

    public static final void dumpValue(PrintWriter out, Value value, boolean useValueTimestamp, boolean crlf) throws IOException {
        Object v = null;
        switch (value.type) {
            case LONG: {
                if (value.value instanceof AtomicLong) {
                    v = ((AtomicLong)value.value).longValue();
                    break;
                }
                v = ((Number)value.value).longValue();
                break;
            }
            case DOUBLE: {
                if (value.value instanceof Double || value.value instanceof Float) {
                    v = ((Number)value.value).doubleValue();
                    break;
                }
                v = Double.longBitsToDouble(((AtomicLong)value.value).longValue());
                break;
            }
            case BOOLEAN: 
            case STRING: {
                v = value.value;
            }
        }
        Sensision.dumpValue(out, value.cls, value.labels, useValueTimestamp ? value.timestamp : System.currentTimeMillis() * TIME_UNITS_PER_MS, value.latitude, value.longitude, value.elevation, v, crlf);
    }

    private static final void dumpValue(PrintWriter out, Value value) throws IOException {
        Sensision.dumpValue(out, value, true, true);
    }

    private static final void dumpValue(PrintWriter out, String name, Map<String, String> labels, long timestamp, Float latitude, Float longitude, Long elevation, Object value, boolean crlf) throws IOException {
        if (null == out) {
            return;
        }
        if (Long.MIN_VALUE != timestamp) {
            out.print(timestamp);
        }
        out.print("/");
        if (null != latitude && null != longitude) {
            out.print(latitude);
            out.print(":");
            out.print(longitude);
        } else if (null != defaultLatitude && null != defaultLongitude) {
            out.print(defaultLatitude);
            out.print(":");
            out.print(defaultLongitude);
        }
        out.print("/");
        if (null != elevation) {
            out.print(elevation);
        } else if (null != defaultElevation) {
            out.print(defaultElevation);
        }
        out.print(" ");
        out.print(URLEncoder.encode(name, "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll("\\+", "%20"));
        out.print("{");
        boolean first = true;
        for (String label : defaultLabels.keySet()) {
            if (labels.containsKey(label)) continue;
            if (!first) {
                out.print(",");
            }
            out.print(URLEncoder.encode(label, "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C").replaceAll("\\+", "%20"));
            out.print("=");
            out.print(URLEncoder.encode(defaultLabels.get(label), "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C").replaceAll("\\+", "%20"));
            first = false;
        }
        for (String label : labels.keySet()) {
            if (!first) {
                out.print(",");
            }
            out.print(URLEncoder.encode(label, "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C").replaceAll("\\+", "%20"));
            out.print("=");
            out.print(URLEncoder.encode(labels.get(label), "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C").replaceAll("\\+", "%20"));
            first = false;
        }
        out.print("}");
        out.print(" ");
        if (value instanceof Long || value instanceof Integer || value instanceof BigInteger) {
            out.print(((Number)value).longValue());
        } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            out.print(((Number)value).doubleValue());
        } else if (value instanceof String) {
            out.print("'");
            out.print(URLEncoder.encode((String)value, "UTF-8").replaceAll("'", "%27").replaceAll("\\+", "%20"));
            out.print("'");
        } else if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                out.print("T");
            } else {
                out.print("F");
            }
        }
        if (crlf) {
            out.print("\r\n");
        }
    }

    public static String getUUID() {
        return uuid;
    }

    public static long getStartTime() {
        return starttime;
    }

    public static File getHomeDir() {
        return new File(System.getProperty(SENSISION_HOME, DEFAULT_SENSISION_HOME));
    }

    public static File getQueueDir() {
        return new File(Sensision.getHomeDir(), SENSISION_QUEUE_SUBDIR);
    }

    public static File getMetricsDir() {
        return new File(Sensision.getHomeDir(), SENSISION_METRICS_SUBDIR);
    }

    public static File getTargetsDir() {
        return new File(Sensision.getHomeDir(), SENSISION_TARGETS_SUBDIR);
    }

    public static Pattern getTargetPattern() {
        return SENSISION_TARGET_PATTERN;
    }

    public static void addDefaultLocation(StringBuilder sb) {
        if (null != defaultLatitude && null != defaultLongitude) {
            sb.append(defaultLatitude);
            sb.append(":");
            sb.append(defaultLongitude);
        }
    }

    public static void addDefaultElevation(StringBuilder sb) {
        if (null != defaultElevation) {
            sb.append(defaultElevation);
        }
    }

    public static void addValueProvider(Iterable<Value> provider) {
        providers.add(provider);
    }

    public static void removeValueProvider(Iterable<Value> provider) {
        providers.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties readConfigFile(String name) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(name));
        Properties props = new Properties();
        try {
            String line;
            int lineno = 0;
            while (null != (line = br.readLine())) {
                ++lineno;
                if ("".equals(line = line.trim()) || line.startsWith("#") || line.startsWith("//") || line.startsWith("--")) continue;
                if (!line.contains("=")) {
                    throw new IOException("Syntax error on line " + lineno);
                }
                String key = line.replaceAll("^([^=]+)=.*$", "$1").trim();
                String value = line.replaceAll("^([^=]+)=", "").trim();
                props.setProperty(key, value);
                if (null == System.getProperty(key)) {
                    System.setProperty(key, value);
                    continue;
                }
                props.setProperty(key, System.getProperty(key));
            }
            Object var8_7 = null;
            if (null == br) return props;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == br) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            br.close();
            return props;
        }
        catch (Exception exception) {}
        return props;
    }

    public static long getCurrentEvent() {
        return eventSequence.get();
    }

    public static List<String> getEvents() {
        return Collections.unmodifiableList(Arrays.asList(events));
    }

    public static void setInstance(String name) {
        instanceName = name;
    }

    public static String getInstance() {
        return instanceName;
    }

    public static long getTimeUnitsPerMs() {
        return TIME_UNITS_PER_MS;
    }

    static /* synthetic */ Map access$000() {
        return values;
    }

    static /* synthetic */ Value access$100(String x0, Map x1, Object x2) {
        return Sensision.getContainer(x0, x1, x2);
    }

    static {
        if (null != System.getProperty(SENSISION_CONFIG_FILE)) {
            try {
                Sensision.readConfigFile(System.getProperty(SENSISION_CONFIG_FILE));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        instanceName = System.getProperty(SENSISION_INSTANCE);
        if (null != System.getProperty(SENSISION_TIME_UNIT)) {
            if ("us".equals(System.getProperty(SENSISION_TIME_UNIT))) {
                TIME_UNITS_PER_MS = 1000L;
            } else if ("ns".equals(System.getProperty(SENSISION_TIME_UNIT))) {
                TIME_UNITS_PER_MS = 1000000L;
            } else if ("ms".equals(System.getProperty(SENSISION_TIME_UNIT))) {
                TIME_UNITS_PER_MS = 1L;
            }
        }
        if (null != System.getProperty(SENSISION_DEFAULT_LABELS)) {
            String[] tokens;
            for (String token : tokens = System.getProperty(SENSISION_DEFAULT_LABELS).trim().split(",")) {
                if (!token.contains("=")) {
                    throw new RuntimeException("Invalid default labels.");
                }
                String[] subtokens = token.trim().split("=");
                if (2 != subtokens.length) {
                    throw new RuntimeException("Invalid default labels.");
                }
                try {
                    String name = URLDecoder.decode(subtokens[0], "UTF-8");
                    String value = URLDecoder.decode(subtokens[1], "UTF-8");
                    if (defaultLabels.containsKey(name)) {
                        throw new RuntimeException("Duplicate label '" + name + "' in default labels.");
                    }
                    defaultLabels.put(name, value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (null != System.getProperty(SENSISION_DEFAULT_LOCATION)) {
            try {
                defaultLatitude = Double.valueOf(System.getProperty(SENSISION_DEFAULT_LOCATION).replaceAll(":.*", ""));
                defaultLongitude = Double.valueOf(System.getProperty(SENSISION_DEFAULT_LOCATION).replaceAll(".*:", ""));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
        }
        if (null != System.getProperty(SENSISION_DEFAULT_ELEVATION)) {
            try {
                defaultElevation = Long.valueOf(System.getProperty(SENSISION_DEFAULT_ELEVATION));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
        }
        server = null != System.getProperty(SENSISION_SERVER_PORT) ? new SensisionMetricsServer() : null;
        dumper = null != System.getProperty(SENSISION_DUMP_PERIOD) ? new SensisionMetricsDumper() : null;
        if ("true".equals(System.getProperty(SENSISION_DISABLE))) {
            disable = true;
        }
        if ("true".equals(System.getProperty(SENSISION_STRING_OPTIMIZE))) {
            useStringIntern = true;
        }
        events = new String[Integer.parseInt(System.getProperty(SENSISION_EVENTS_HISTORY, "0"))];
        eventsDir = System.getProperty(SENSISION_EVENTS_DIR);
        eventsSuffix = System.getProperty(SENSISION_EVENTS_SUFFIX);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (null != System.getProperty(Sensision.SENSISION_DUMP_ONEXIT)) {
                    SensisionMetricsDumper.flushMetrics(null);
                }
                Sensision.flushEvents();
            }
        });
        curator = new MetricsCurator();
        eventSequence = new AtomicLong(-1L);
        eventsFile = null;
        eventsWriter = null;
        instanceName = null;
        values = new ConcurrentHashMap<String, Map<Map<String, String>, Value>>();
        MEASUREMENT_RE = Pattern.compile("^([0-9]+)?/(([0-9.-]+):([0-9.-]+))?/([0-9-]+)? +([^ ]+)\\{([^\\}]*)\\} +(.+)$");
        STRING_VALUE_RE = Pattern.compile("^['\"].*['\"]$");
        BOOLEAN_VALUE_RE = Pattern.compile("^(T|F|true|false)$", 2);
        LONG_VALUE_RE = Pattern.compile("^[+-]?[0-9]+$");
        DOUBLE_VALUE_RE = Pattern.compile("^[+-]?([0-9]+)\\.([0-9]+)(E\\-?[0-9]+)?$");
    }

    private static final class MetricsCurator
    extends Thread {
        private static final long DEFAULT_CURATION_PERIOD = 10000L;
        private long period;

        public MetricsCurator() {
            if (disable) {
                return;
            }
            if (null == System.getProperty(Sensision.SENSISION_CURATION_PERIOD)) {
                return;
            }
            try {
                this.period = Long.valueOf(System.getProperty(Sensision.SENSISION_CURATION_PERIOD));
            }
            catch (NumberFormatException nfe) {
                this.period = 10000L;
            }
            this.setDaemon(true);
            this.setName("[Sensision MetricsCurator (" + this.period + ")]");
            this.start();
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Value {
        TYPE type = null;
        String cls;
        Map<String, String> labels;
        long timestamp;
        Float latitude = null;
        Float longitude = null;
        Long elevation = null;
        Object value;
        Long expire;

        protected Value() {
        }

        public Value(String name, Map<String, String> labels, long timestamp, Float latitude, Float longitude, Long elevation, Object value) {
            this.cls = name;
            this.labels = labels;
            this.timestamp = timestamp;
            this.latitude = latitude;
            this.longitude = longitude;
            this.elevation = elevation;
            if (value instanceof Long || value instanceof Integer || value instanceof BigInteger) {
                this.type = TYPE.LONG;
                this.value = ((Number)value).longValue();
            } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                this.type = TYPE.DOUBLE;
                this.value = ((Number)value).doubleValue();
            } else if (value instanceof Boolean) {
                this.type = TYPE.BOOLEAN;
                this.value = value;
            } else {
                this.type = TYPE.STRING;
                this.value = value.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum TYPE {
            LONG,
            DOUBLE,
            STRING,
            BOOLEAN;

        }
    }
}

