/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.hadoop;

import io.warp10.sensision.Sensision;
import java.util.HashMap;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class SensisionSink
implements MetricsSink {
    public static String HADOOP_SENSISION_TTL = "hadoop.sensision.ttl";
    private static final String SENSISION_SINK_PREFIX = "sensision.sink.prefix";
    private String prefix = "";
    private Long ttl = null;

    public SensisionSink() {
        if (null != System.getProperty(HADOOP_SENSISION_TTL)) {
            this.ttl = Long.parseLong(System.getProperty(HADOOP_SENSISION_TTL));
        }
    }

    public void flush() {
    }

    public void init(SubsetConfiguration config) {
        this.prefix = System.getProperty(SENSISION_SINK_PREFIX, "");
    }

    public void putMetrics(MetricsRecord record) {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (MetricsTag tag : record.tags()) {
            if (null == tag.value()) continue;
            labels.put(tag.name(), tag.value());
        }
        StringBuilder sb = new StringBuilder();
        for (AbstractMetric metric : record.metrics()) {
            sb.setLength(0);
            sb.append(this.prefix);
            sb.append(metric.name());
            String cls = sb.toString();
            Sensision.set(cls, labels, record.timestamp() * Sensision.TIME_UNITS_PER_MS, null, null, null, metric.value(), this.ttl);
        }
    }
}

