/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio;

import io.warp10.sensision.jarjar.org.eclipse.jetty.io.AsyncEndPoint;
import io.warp10.sensision.jarjar.org.eclipse.jetty.io.ConnectedEndPoint;
import io.warp10.sensision.jarjar.org.eclipse.jetty.io.Connection;
import io.warp10.sensision.jarjar.org.eclipse.jetty.io.EndPoint;
import io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.AsyncConnection;
import io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.TypeUtil;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.component.AbstractLifeCycle;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.component.AggregateLifeCycle;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.component.Dumpable;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Log;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Logger;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.thread.Timeout;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class SelectorManager
extends AbstractLifeCycle
implements Dumpable {
    public static final Logger LOG = Log.getLogger("io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio");
    private static final int __MONITOR_PERIOD = Integer.getInteger("io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.MAX_SELECTS", 100000);
    private static final int __BUSY_PAUSE = Integer.getInteger("io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.BUSY_PAUSE", 50);
    private static final int __IDLE_TICK = Integer.getInteger("io.warp10.sensision.jarjar.org.eclipse.jetty.io.nio.IDLE_TICK", 400);
    private int _maxIdleTime;
    private int _lowResourcesMaxIdleTime;
    private long _lowResourcesConnections;
    private SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set = 0;
    private boolean _deferringInterestedOps0 = true;
    private int _selectorPriorityDelta = 0;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = (int)maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public SelectSet getSelectSet(int i) {
        return this._selectSet[i];
    }

    public void register(SocketChannel channel, Object att) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(SocketChannel channel) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public int getSelectorPriorityDelta() {
        return this._selectorPriorityDelta;
    }

    public void setSelectorPriorityDelta(int delta) {
        this._selectorPriorityDelta = delta;
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = (int)lowResourcesMaxIdleTime;
    }

    public abstract boolean dispatch(Runnable var1);

    @Override
    protected void doStart() throws Exception {
        int i;
        this._selectSet = new SelectSet[this._selectSets];
        for (i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
        i = 0;
        while (i < this.getSelectSets()) {
            int id;
            boolean selecting;
            if (selecting = this.dispatch(new Runnable(id = i++){
                final /* synthetic */ int val$id;
                {
                    this.val$id = n;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SelectSet[] sets;
                    int priority;
                    String name;
                    block11: {
                        name = Thread.currentThread().getName();
                        priority = Thread.currentThread().getPriority();
                        sets = SelectorManager.this._selectSet;
                        if (sets != null) break block11;
                        LOG.debug("Stopped {} on {}", Thread.currentThread(), this);
                        Thread.currentThread().setName(name);
                        if (SelectorManager.this.getSelectorPriorityDelta() != 0) {
                            Thread.currentThread().setPriority(priority);
                        }
                        return;
                    }
                    try {
                        SelectSet set = sets[this.val$id];
                        Thread.currentThread().setName(name + " Selector" + this.val$id);
                        if (SelectorManager.this.getSelectorPriorityDelta() != 0) {
                            Thread.currentThread().setPriority(Thread.currentThread().getPriority() + SelectorManager.this.getSelectorPriorityDelta());
                        }
                        LOG.debug("Starting {} on {}", Thread.currentThread(), this);
                        while (SelectorManager.this.isRunning()) {
                            try {
                                set.doSelect();
                            }
                            catch (IOException e) {
                                LOG.ignore(e);
                            }
                            catch (Exception e) {
                                LOG.warn(e);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.debug("Stopped {} on {}", Thread.currentThread(), this);
                        Thread.currentThread().setName(name);
                        if (SelectorManager.this.getSelectorPriorityDelta() != 0) {
                            Thread.currentThread().setPriority(priority);
                        }
                        throw throwable;
                    }
                    LOG.debug("Stopped {} on {}", Thread.currentThread(), this);
                    Thread.currentThread().setName(name);
                    if (SelectorManager.this.getSelectorPriorityDelta() != 0) {
                        Thread.currentThread().setPriority(priority);
                    }
                }
            })) continue;
            throw new IllegalStateException("!Selecting");
        }
    }

    @Override
    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (SelectSet set : sets) {
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract void endPointUpgraded(ConnectedEndPoint var1, Connection var2);

    public abstract AsyncConnection newConnection(SocketChannel var1, AsyncEndPoint var2, Object var3);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        LOG.warn(ex + "," + channel + "," + attachment, new Object[0]);
        LOG.debug(ex);
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        AggregateLifeCycle.dumpObject(out, this);
        AggregateLifeCycle.dump(out, indent, TypeUtil.asList(this._selectSet));
    }

    public boolean isDeferringInterestedOps0() {
        return this._deferringInterestedOps0;
    }

    public void setDeferringInterestedOps0(boolean deferringInterestedOps0) {
        this._deferringInterestedOps0 = deferringInterestedOps0;
    }

    private static interface ChangeTask
    extends Runnable {
    }

    private static class ChannelAndAttachment {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChannelAndAttachment(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet
    implements Dumpable {
        private final int _setID;
        private final Timeout _timeout;
        private final ConcurrentLinkedQueue<Object> _changes = new ConcurrentLinkedQueue();
        private volatile Selector _selector;
        private volatile Thread _selecting;
        private int _busySelects;
        private long _monitorNext;
        private boolean _pausing;
        private boolean _paused;
        private volatile long _idleTick;
        private ConcurrentMap<SelectChannelEndPoint, Object> _endPoints = new ConcurrentHashMap<SelectChannelEndPoint, Object>();

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTick = System.currentTimeMillis();
            this._timeout = new Timeout(this);
            this._timeout.setDuration(0L);
            this._selector = Selector.open();
            this._monitorNext = System.currentTimeMillis() + (long)__MONITOR_PERIOD;
        }

        public void addChange(Object change) {
            this._changes.add(change);
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChannelAndAttachment(channel, att));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doSelect() throws IOException {
            try {
                Object change;
                this._selecting = Thread.currentThread();
                Selector selector = this._selector;
                if (selector == null) {
                    return;
                }
                int changes = this._changes.size();
                while (changes-- > 0 && (change = this._changes.poll()) != null) {
                    Channel ch = null;
                    SelectionKey key = null;
                    try {
                        if (change instanceof EndPoint) {
                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)change;
                            ch = endpoint.getChannel();
                            endpoint.doUpdateKey();
                            continue;
                        }
                        if (change instanceof ChannelAndAttachment) {
                            ChannelAndAttachment asc = (ChannelAndAttachment)change;
                            SelectableChannel channel = asc._channel;
                            ch = channel;
                            Object att = asc._attachment;
                            if (channel instanceof SocketChannel && ((SocketChannel)channel).isConnected()) {
                                key = channel.register(selector, 1, att);
                                SelectChannelEndPoint endpoint = this.createEndPoint((SocketChannel)channel, key);
                                key.attach(endpoint);
                                endpoint.schedule();
                                continue;
                            }
                            if (!channel.isOpen()) continue;
                            key = channel.register(selector, 8, att);
                            continue;
                        }
                        if (change instanceof SocketChannel) {
                            SocketChannel channel = (SocketChannel)change;
                            ch = channel;
                            key = channel.register(selector, 1, null);
                            SelectChannelEndPoint endpoint = this.createEndPoint(channel, key);
                            key.attach(endpoint);
                            endpoint.schedule();
                            continue;
                        }
                        if (change instanceof ChangeTask) {
                            ((Runnable)change).run();
                            continue;
                        }
                        if (change instanceof Runnable) {
                            SelectorManager.this.dispatch((Runnable)change);
                            continue;
                        }
                        throw new IllegalArgumentException(change.toString());
                    }
                    catch (CancelledKeyException e) {
                        LOG.ignore(e);
                    }
                    catch (Throwable e) {
                        if (SelectorManager.this.isRunning()) {
                            LOG.warn(e);
                        } else {
                            LOG.debug(e);
                        }
                        try {
                            if (ch == null) continue;
                            ch.close();
                        }
                        catch (IOException e2) {
                            LOG.debug(e2);
                        }
                    }
                }
                int selected = selector.selectNow();
                long now = System.currentTimeMillis();
                if (selected == 0 && selector.selectedKeys().isEmpty()) {
                    long wait;
                    if (this._pausing) {
                        try {
                            Thread.sleep(__BUSY_PAUSE);
                        }
                        catch (InterruptedException e) {
                            LOG.ignore(e);
                        }
                        now = System.currentTimeMillis();
                    }
                    this._timeout.setNow(now);
                    long to_next_timeout = this._timeout.getTimeToNext();
                    long l = wait = this._changes.size() == 0 ? (long)__IDLE_TICK : 0L;
                    if (wait > 0L && to_next_timeout >= 0L && wait > to_next_timeout) {
                        wait = to_next_timeout;
                    }
                    if (wait > 0L) {
                        long before = now;
                        selector.select(wait);
                        now = System.currentTimeMillis();
                        this._timeout.setNow(now);
                        if (__MONITOR_PERIOD > 0 && now - before <= 1L && ++this._busySelects > __MAX_SELECTS) {
                            this._pausing = true;
                            if (!this._paused) {
                                this._paused = true;
                                LOG.warn("Selector {} is too busy, pausing!", this);
                            }
                        }
                    }
                }
                if (this._selector == null || !selector.isOpen()) {
                    return;
                }
                for (SelectionKey key : selector.selectedKeys()) {
                    AbstractInterruptibleChannel channel = null;
                    try {
                        if (!key.isValid()) {
                            key.cancel();
                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)key.attachment();
                            if (endpoint == null) continue;
                            endpoint.doUpdateKey();
                            continue;
                        }
                        Object att = key.attachment();
                        if (att instanceof SelectChannelEndPoint) {
                            if (key.isReadable() || key.isWritable()) {
                                ((SelectChannelEndPoint)att).schedule();
                            }
                        } else if (key.isConnectable()) {
                            channel = (SocketChannel)key.channel();
                            boolean connected = false;
                            try {
                                connected = ((SocketChannel)channel).finishConnect();
                            }
                            catch (Exception e) {
                                SelectorManager.this.connectionFailed((SocketChannel)channel, e, att);
                            }
                            finally {
                                if (connected) {
                                    key.interestOps(1);
                                    SelectChannelEndPoint endpoint = this.createEndPoint((SocketChannel)channel, key);
                                    key.attach(endpoint);
                                    endpoint.schedule();
                                } else {
                                    key.cancel();
                                }
                            }
                        } else {
                            channel = (SocketChannel)key.channel();
                            SelectChannelEndPoint endpoint = this.createEndPoint((SocketChannel)channel, key);
                            key.attach(endpoint);
                            if (key.isReadable()) {
                                endpoint.schedule();
                            }
                        }
                        key = null;
                    }
                    catch (CancelledKeyException e) {
                        LOG.ignore(e);
                    }
                    catch (Exception e) {
                        if (SelectorManager.this.isRunning()) {
                            LOG.warn(e);
                        } else {
                            LOG.ignore(e);
                        }
                        try {
                            if (channel != null) {
                                channel.close();
                            }
                        }
                        catch (IOException e2) {
                            LOG.debug(e2);
                        }
                        if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                        key.cancel();
                    }
                }
                selector.selectedKeys().clear();
                now = System.currentTimeMillis();
                this._timeout.setNow(now);
                Timeout.Task task = this._timeout.expired();
                while (task != null) {
                    if (task instanceof Runnable) {
                        SelectorManager.this.dispatch((Runnable)((Object)task));
                    }
                    task = this._timeout.expired();
                }
                if (now - this._idleTick > (long)__IDLE_TICK) {
                    this._idleTick = now;
                    final long idle_now = SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections ? now + (long)SelectorManager.this._maxIdleTime - (long)SelectorManager.this._lowResourcesMaxIdleTime : now;
                    SelectorManager.this.dispatch(new Runnable(){

                        @Override
                        public void run() {
                            for (SelectChannelEndPoint endp : SelectSet.this._endPoints.keySet()) {
                                endp.checkIdleTimestamp(idle_now);
                            }
                        }

                        public String toString() {
                            return "Idle-" + super.toString();
                        }
                    });
                }
                if (__MONITOR_PERIOD > 0 && now > this._monitorNext) {
                    this._busySelects = 0;
                    this._pausing = false;
                    this._monitorNext = now + (long)__MONITOR_PERIOD;
                }
            }
            catch (ClosedSelectorException e) {
                if (SelectorManager.this.isRunning()) {
                    LOG.warn(e);
                } else {
                    LOG.ignore(e);
                }
            }
            catch (CancelledKeyException e) {
                LOG.ignore(e);
            }
            finally {
                this._selecting = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renewSelector() {
            try {
                SelectSet selectSet = this;
                synchronized (selectSet) {
                    Selector selector = this._selector;
                    if (selector == null) {
                        return;
                    }
                    Selector new_selector = Selector.open();
                    for (SelectionKey k : selector.keys()) {
                        if (!k.isValid() || k.interestOps() == 0) continue;
                        SelectableChannel channel = k.channel();
                        Object attachment = k.attachment();
                        if (attachment == null) {
                            this.addChange(channel);
                            continue;
                        }
                        this.addChange(channel, attachment);
                    }
                    this._selector.close();
                    this._selector = new_selector;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("recreating selector", e);
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._timeout.getNow();
        }

        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            if (!(task instanceof Runnable)) {
                throw new IllegalArgumentException("!Runnable");
            }
            this._timeout.schedule(task, timeoutMs);
        }

        public void cancelTimeout(Timeout.Task task) {
            task.cancel();
        }

        public void wakeup() {
            try {
                Selector selector = this._selector;
                if (selector != null) {
                    selector.wakeup();
                }
            }
            catch (Exception e) {
                this.addChange(new ChangeTask(){

                    @Override
                    public void run() {
                        SelectSet.this.renewSelector();
                    }
                });
                this.renewSelector();
            }
        }

        private SelectChannelEndPoint createEndPoint(SocketChannel channel, SelectionKey sKey) throws IOException {
            SelectChannelEndPoint endp = SelectorManager.this.newEndPoint(channel, this, sKey);
            LOG.debug("created {}", endp);
            SelectorManager.this.endPointOpened(endp);
            this._endPoints.put(endp, this);
            return endp;
        }

        public void destroyEndPoint(SelectChannelEndPoint endp) {
            LOG.debug("destroyEndPoint {}", endp);
            this._endPoints.remove(endp);
            SelectorManager.this.endPointClosed(endp);
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            try {
                for (int i = 0; i < 100 && this._selecting != null; ++i) {
                    this.wakeup();
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                LOG.ignore(e);
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                Selector selector = this._selector;
                for (SelectionKey key : selector.keys()) {
                    Object att;
                    if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                    EndPoint endpoint = (EndPoint)att;
                    try {
                        endpoint.close();
                    }
                    catch (IOException e) {
                        LOG.ignore(e);
                    }
                }
                this._timeout.cancelAll();
                try {
                    selector = this._selector;
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException e) {
                    LOG.ignore(e);
                }
                this._selector = null;
            }
        }

        @Override
        public String dump() {
            return AggregateLifeCycle.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Selector selector;
            StackTraceElement[] trace;
            out.append(String.valueOf(this)).append(" id=").append(String.valueOf(this._setID)).append("\n");
            Thread selecting = this._selecting;
            Object where = "not selecting";
            StackTraceElement[] stackTraceElementArray = trace = selecting == null ? null : selecting.getStackTrace();
            if (trace != null) {
                for (StackTraceElement t : trace) {
                    if (!t.getClassName().startsWith("io.warp10.sensision.jarjar.org.eclipse.jetty.")) continue;
                    where = t;
                    break;
                }
            }
            if ((selector = this._selector) != null) {
                final ArrayList<String> dump = new ArrayList<String>(selector.keys().size() * 2);
                dump.add((String)where);
                final CountDownLatch latch = new CountDownLatch(1);
                this.addChange(new ChangeTask(){

                    @Override
                    public void run() {
                        SelectSet.this.dumpKeyState(dump);
                        latch.countDown();
                    }
                });
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.ignore(e);
                }
                AggregateLifeCycle.dump(out, indent, dump);
            }
        }

        public void dumpKeyState(List<Object> dumpto) {
            Selector selector = this._selector;
            Set<SelectionKey> keys = selector.keys();
            dumpto.add(selector + " keys=" + keys.size());
            for (SelectionKey key : keys) {
                if (key.isValid()) {
                    dumpto.add(key.attachment() + " iOps=" + key.interestOps() + " rOps=" + key.readyOps());
                    continue;
                }
                dumpto.add(key.attachment() + " iOps=-1 rOps=-1");
            }
        }

        public String toString() {
            Selector selector = this._selector;
            return String.format("%s keys=%d selected=%d", super.toString(), selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1);
        }
    }
}

