/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.jetty.deployer;

import io.warp10.sensision.jarjar.org.mortbay.component.AbstractLifeCycle;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Handler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HandlerContainer;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandlerCollection;
import io.warp10.sensision.jarjar.org.mortbay.jetty.webapp.WebAppContext;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import io.warp10.sensision.jarjar.org.mortbay.resource.Resource;
import java.util.ArrayList;

public class WebAppDeployer
extends AbstractLifeCycle {
    private HandlerContainer _contexts;
    private String _webAppDir;
    private String _defaultsDescriptor;
    private String[] _configurationClasses;
    private boolean _extract;
    private boolean _parentLoaderPriority;
    private boolean _allowDuplicates;
    private ArrayList _deployed;
    static /* synthetic */ Class class$org$mortbay$jetty$handler$ContextHandler;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebAppContext;

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setConfigurationClasses(String[] configurationClasses) {
        this._configurationClasses = configurationClasses;
    }

    public HandlerContainer getContexts() {
        return this._contexts;
    }

    public void setContexts(HandlerContainer contexts) {
        this._contexts = contexts;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public boolean isExtract() {
        return this._extract;
    }

    public void setExtract(boolean extract) {
        this._extract = extract;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentPriorityClassLoading) {
        this._parentLoaderPriority = parentPriorityClassLoading;
    }

    public String getWebAppDir() {
        return this._webAppDir;
    }

    public void setWebAppDir(String dir) {
        this._webAppDir = dir;
    }

    public boolean getAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public void doStart() throws Exception {
        this._deployed = new ArrayList();
        this.scan();
    }

    public void scan() throws Exception {
        if (this._contexts == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        Resource r = Resource.newResource(this._webAppDir);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        block4: for (int f = 0; files != null && f < files.length; ++f) {
            Resource unpacked;
            String context = files[f];
            if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
            Resource app = r.addPath(r.encode(context));
            if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") ? !app.isDirectory() : (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
            context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context;
            if (context.endsWith("/") && context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
            if (!this._allowDuplicates) {
                Handler[] installed = this._contexts.getChildHandlersByClass(class$org$mortbay$jetty$handler$ContextHandler == null ? WebAppDeployer.class$("io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandler") : class$org$mortbay$jetty$handler$ContextHandler);
                for (int i = 0; i < installed.length; ++i) {
                    ContextHandler c = (ContextHandler)installed[i];
                    if (context.equals(c.getContextPath())) continue block4;
                    try {
                        String path = null;
                        if (c instanceof WebAppContext) {
                            path = Resource.newResource(((WebAppContext)c).getWar()).getFile().getAbsolutePath();
                        } else if (c.getBaseResource() != null) {
                            path = c.getBaseResource().getFile().getAbsolutePath();
                        }
                        if (path == null || !path.equals(app.getFile().getAbsolutePath())) continue;
                        continue block4;
                    }
                    catch (Exception e) {
                        Log.ignore(e);
                    }
                }
            }
            WebAppContext wah = null;
            if (this._contexts instanceof ContextHandlerCollection && (class$org$mortbay$jetty$webapp$WebAppContext == null ? WebAppDeployer.class$("io.warp10.sensision.jarjar.org.mortbay.jetty.webapp.WebAppContext") : class$org$mortbay$jetty$webapp$WebAppContext).isAssignableFrom(((ContextHandlerCollection)this._contexts).getContextClass())) {
                try {
                    wah = (WebAppContext)((ContextHandlerCollection)this._contexts).getContextClass().newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                wah = new WebAppContext();
            }
            wah.setContextPath(context);
            if (this._configurationClasses != null) {
                wah.setConfigurationClasses(this._configurationClasses);
            }
            if (this._defaultsDescriptor != null) {
                wah.setDefaultsDescriptor(this._defaultsDescriptor);
            }
            wah.setExtractWAR(this._extract);
            wah.setWar(app.toString());
            wah.setParentLoaderPriority(this._parentLoaderPriority);
            this._contexts.addHandler(wah);
            this._deployed.add(wah);
            if (!this._contexts.isStarted()) continue;
            wah.start();
        }
    }

    public void doStop() throws Exception {
        int i = this._deployed.size();
        while (i-- > 0) {
            ContextHandler wac = (ContextHandler)this._deployed.get(i);
            wac.stop();
        }
    }
}

