/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.jetty.handler;

import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Request;
import io.warp10.sensision.jarjar.org.mortbay.jetty.RequestLog;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Response;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Server;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.HandlerWrapper;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import java.io.IOException;

public class RequestLogHandler
extends HandlerWrapper {
    private RequestLog _requestLog;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        super.handle(target, request, response, dispatch);
        if (dispatch == 1 && this._requestLog != null) {
            this._requestLog.log((Request)request, (Response)response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._requestLog, requestLog, "logimpl", true);
        }
        this._requestLog = requestLog;
        try {
            if (this.isStarted() && this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setServer(Server server) {
        if (this._requestLog != null) {
            if (this.getServer() != null && this.getServer() != server) {
                this.getServer().getContainer().update((Object)this, this._requestLog, null, "logimpl", true);
            }
            super.setServer(server);
            if (server != null && server != this.getServer()) {
                server.getContainer().update((Object)this, null, this._requestLog, "logimpl", true);
            }
        } else {
            super.setServer(server);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._requestLog != null) {
            this._requestLog.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._requestLog != null) {
            this._requestLog.stop();
        }
    }
}

