/*
 * Decompiled with CFR 0.152.
 */
package org.boon.service;

import java.util.Map;
import org.boon.core.Conversions;

public class Response {
    private final int status;
    private final Object headers;
    private final Object statusMessage;
    private final Object payload;
    private final Class<? extends Enum> enumStatusClass;

    public Response(int status, Object headers, Object statusMessage, Object payload) {
        this.status = status;
        this.headers = headers;
        this.statusMessage = statusMessage;
        this.payload = payload;
        this.enumStatusClass = null;
    }

    public Response(int status, Object headers, Object statusMessage, Object payload, Class<? extends Enum> enumStatusClass) {
        this.status = status;
        this.headers = headers;
        this.statusMessage = statusMessage;
        this.payload = payload;
        this.enumStatusClass = enumStatusClass;
    }

    public int status() {
        return this.status;
    }

    public <E extends Enum> E statusEnum(Class<E> enumClass) {
        return Conversions.toEnum(enumClass, this.status);
    }

    public Enum statusEnum() {
        return Conversions.toEnum(this.enumStatusClass, this.status);
    }

    public Object headers() {
        return this.headers;
    }

    public Map<String, Object> headerMap() {
        return Conversions.toMap(this.headers);
    }

    public Object statusMessage() {
        return this.statusMessage;
    }

    public String statusMessageAsString() {
        return Conversions.toString(this.statusMessage);
    }

    public Object payload() {
        return this.payload;
    }

    public String payloadAsString() {
        return Conversions.toString(this.payload);
    }

    public static Response response(int status, Map headers, String statusMessage, String payload) {
        return new Response(status, headers, statusMessage, payload);
    }
}

