# -*- coding: utf-8 -*-
import dataiku
import numpy as np
import pandas as pd
from sklearn.metrics import roc_auc_score

# Recipe inputs
df1 = dataiku.Dataset("test_scored_baseline").get_dataframe()
df2 = dataiku.Dataset("test_scored_scikit").get_dataframe()
df3 = dataiku.Dataset("test_scored_r").get_dataframe()
df4 = dataiku.Dataset("test_scored_h2o").get_dataframe()
df5 = dataiku.Dataset("test_scored_vw").get_dataframe()

# Measure AUC
print '[+] Building AUC for model 1...'
auc1 = roc_auc_score(df1['Churn'].astype(bool).values, df1['proba_True'].values)
auc1 = pd.Series(auc1, name='auc')
auc1 = pd.DataFrame(auc1)
auc1['model'] = 'DSS RF'

print '[+] Building AUC for model 2...'
auc2 = roc_auc_score(df2['Churn'].astype(bool).values, df2['proba_True'].values)
auc2 = pd.Series(auc2, name='auc')
auc2 = pd.DataFrame(auc2)
auc2['model'] = 'Manual Scikit'

print '[+] Building AUC for model 3...'
auc3 = roc_auc_score(df3['Churn'].astype(bool).values, df3['True'].values)
auc3 = pd.Series(auc3, name='auc')
auc3 = pd.DataFrame(auc3)
auc3['model'] = 'Manual R'

print '[+] Building AUC for model 4...'
auc4 = roc_auc_score(df4['Churn'].astype(bool).values, df4['True'].values)
auc4 = pd.Series(auc4, name='auc')
auc4 = pd.DataFrame(auc4)
auc4['model'] = 'H2O'

print '[+] Building AUC for model 5...'
auc5 = roc_auc_score(df5['Churn'].astype(bool).values, df5['probability'].values)
auc5 = pd.Series(auc5, name='auc')
auc5 = pd.DataFrame(auc5)
auc5['model'] = 'VW'

auc = pd.concat((auc1, auc2, auc3, auc4, auc5), axis=0)


# Recipe outputs
auc_results = dataiku.Dataset("auc_results")
auc_results.write_with_schema(auc)
