# -*- coding: utf-8 -*-
import dataiku
from dataiku import Dataset
import pandas as pd
import foursquare
import time
import os
import exceptions
import json
import numpy as np

#### param input #####

client_id='JWXRGWNGD0OPZ2AXBQTQT13EGQI4R0UQOQXA2BJKPIJAYLIX'
client_secret='dataiku_secret'
directory='some_local_path'
sleep_time=0.75

######################

# Recipe inputs
iris = dataiku.Dataset("iris_centroids").get_dataframe()

client = foursquare.Foursquare(client_id=client_id, client_secret=client_secret)
categories = client.venues.categories()['categories']


def get4sqData(client, sw, ne, poly_id, categId, categName, path):
    directory2Write = path+'/'+categName
    if not os.path.exists(directory2Write):
        os.makedirs(directory2Write)
    place2Write = directory2Write+'/'+poly_id
    data = client.venues.search(params={
        'sw': sw,
        'ne': ne,
        'query': '',
        'limit':50,
        'intent':'browse',
        'categoryId': categId
        })
    time.sleep(sleep_time)
    for i in data['venues']:
        i['poly_id'] = poly_id
    with open(place2Write, 'w') as f:
        f.write(json.dumps(data['venues']))
        
def get4sqAllCateg(cat, client, sw, ne, poly_id, path):
    for categ in cat:
        try :
            get4sqData(client, sw, ne, poly_id, categ['id'], categ['name'], path)
        except Exception:
            pass
        
        
def writeDataDSS(cat,poly_id,path):
    res=pd.read_json(path_or_buf=path+'/'+cat+'/'+poly_id,orient='records')
    if len(res)>0:
        res['category']=cat
        return res
    else:
        return pd.DataFrame()
        

out=pd.DataFrame()               
c=0
for categ in categories:
    print categ['name']
    for row in iris.iterrows():
        print row[1].IRIS
        c=c+1
        lon, lat = [float(x) for x in row[1].iris_centroid[6:-1].split(" ")]
        sw = unicode(lat-row[1].iris_radius_degrees) + ',' + unicode(lon-row[1].iris_radius_degrees)
        ne = unicode(lat+row[1].iris_radius_degrees) + ',' + unicode(lon+row[1].iris_radius_degrees) 
        get4sqAllCateg(categories, client, sw=sw, ne=ne, poly_id = str(int(row[1].IRIS)), path = directory)
        out=pd.concat([out,writeDataDSS(categ['name'], poly_id = str(int(row[1].IRIS)), path = directory)])
    

out['contact']=out['contact'].map(lambda x: json.dumps(x))
out['location']=out['location'].map(lambda x: json.dumps(x))
out['stats']=out['stats'].map(lambda x: json.dumps(x))
out['attribution'] = out['id'].map(lambda x: 'https://foursquare.com/v/'+x+'?ref='+client_id)

out=out[['category','contact','location','stats','name','poly_id','attribution']]

foursquare = dataiku.Dataset("foursquare_iris")
foursquare.write_with_schema(out)