SELECT s."IRIS",
       s.iris_centroid,
       s."geojson",
       s."NOM_IRIS",
       SUM(CASE when s.category='shop' then 1 else 0 END) as nb_shop,
       SUM(CASE when s.category='food' then 1 else 0 END) as nb_food,
       SUM(CASE when s.category='minor_transport' then 1 else 0 END) as nb_minor_transport,
       SUM(CASE when s.category='entertainment' then 1 else 0 END) as nb_entertainment,
       SUM(CASE when s.category='supermarket' then 1 else 0 END) as nb_supermarket,
       SUM(CASE when s.category='transport' then 1 else 0 END) as nb_transport,
       SUM(CASE when s.category='parking' then 1 else 0 END) as nb_parking,
       SUM(CASE when s.category='public_service' then 1 else 0 END) as nb_public_service

FROM
( SELECT g."IRIS", p.category, ST_ASTEXT(ST_CENTROID(ST_GeomFromText(ST_AsText(g.the_geom), 4326))) as iris_centroid, g."geojson", g."NOM_IRIS"
FROM "contour_iris_paris_geojson" g
JOIN "poi_osm" p
ON ST_within(p.position, ST_TRANSFORM(ST_GeomFromText(ST_AsText(g.the_geom), 4326),27561))
) s
GROUP BY s."IRIS", s.iris_centroid, s."geojson", s."NOM_IRIS"