/**
 * This template loads a DSS dataset containing geographical points and displays them on a world map.
 *
 * This is a simple "static" map: a whole dataset is shown. Each row of the dataset gets one circle on the map, with a popup.
 *
 * This template uses the 'leaflet' library.
 *
 * In this template, we assume that there are "latitude" and "longitude" columns.
 */

// Create a Map
var map = L.map('map').setView([48.859, 2.35], 12);

// Add an OpenStreetMap(c) based background
var cartodb =  new  L.tileLayer(
    'http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="http://cartodb.com/attributions">CartoDB</a>, &copy data provided by <a href="https://foursquare.com/">Foursquare</a>'
})
map.addLayer(cartodb);


// Global vars
var dataDict = {};
var clusterDict = {};
var defName = {};
var colorDict = {"Residential with services": "#fdc766",
                 "Parks or low density": "#7bc9a6",
                 "Residential": "#f06548",
                 "Getting out": "#548ecb",
                 "Touristic areas & hubs": "#4ec5da"
                 
                };

function loadIris(){
    
    dataiku.fetch('heatmap_iris_osm_joined_scored', function(dataFrame) {
        console.log(dataFrame.getColumnNames());
        //console.log(dataFrame.getRows());

        data = dataFrame.getRows();
        col = dataFrame.getColumnNames();
        console.log(col);
        
        for (var idx = 0; idx < data.length; idx++) { 
            clusterDict[data[idx][0]] = {"nom":data[idx][3], "label": data[idx][24], "polygon": jQuery.parseJSON(data[idx][2])};
        }
        
        drawIris();
    })
};


function drawIris(){

    d3.select("#map").selectAll("g").remove();
    d3.select("#legendName").selectAll("*").remove();
    d3.select("#legend").selectAll("*").remove();
    //   d3.select("h2").text(valeur); 
    
    for (var key in clusterDict) {

        var geojsonFeature = {
        "type": "Feature",
        "properties": {
        "name": "maille"
        }
        };
        var style = {
            "value": clusterDict[key],
            "color": colorDict[clusterDict[key]['label']],
            "weight": 5,
            "fillColor" : colorDict[clusterDict[key]['label']],
            "opacity": 0,
            "fillOpacity": 0.5
        };

        geojsonFeature['geometry'] = clusterDict[key]["polygon"];

        var maille = L.geoJson(geojsonFeature, style); 
        var msg = "";

        msg = clusterDict[key]['nom'] +' | '+ clusterDict[key]['label'];
        maille.bindPopup(msg)
        maille.addTo(map)
    }
};


function main(){
    loadIris();
};

main();

