# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from my_package import extract_domain

# Read recipe inputs
inp = dataiku.Dataset("contacts")
out = dataiku.Dataset("contacts_2")

# Set schema of the output dataset
schema = inp.read_schema()
schema.append({"type": "string", "name" : "new_feat"})
print(schema)
out.write_schema(schema)

#Copy over data + enrichments
input_df = inp.get_dataframe()
with out.get_writer() as writer:
    for index, row in input_df.iterrows():
        row['new_feat'] = extract_domain(row['Email'])
        writer.write_row_array(row)
