# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd
import io
import json

folder = dataiku.Folder("UZu8GFBh")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
df = None

for path in folder.list_paths_in_partition():
    if "eval_results_table.json" in path:
        with folder.get_download_stream(path) as stream:
            buf = io.BytesIO(stream.read())
            d = json.loads(buf.read())
            if df is None:
                df = pd.DataFrame.from_dict(d["data"])
                df.columns = d["columns"]
            else:
                new_df = pd.DataFrame.from_dict(d["data"])
                new_df.columns = d["columns"]
                df = pd.concat((df, new_df), axis=0, ignore_index=True)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
dataiku.Dataset("answers_evaluated").write_with_schema(df)
