import dataiku
import re
from logging import (info, warning, error)
from dataiku.core.sql import SQLExecutor2

def format_key_val(k,v):
    #return f"{k} = '{v}'" # old version
    return f'"{k}"' + f" = '{v}'"

def get_sql_table_name(dataset):
    table_name = dataset.get_config()["params"]["table"]
    proj_var_refs = re.findall(r'(\${[A-Za-z0-9\-\_]*})', table_name)
    for project_var_ref in proj_var_refs:
        variable = project_var_ref[2:-1]
        dku_vars = dataiku.get_custom_variables()
        if variable in dku_vars.keys():
            value = dku_vars[variable]
            table_name = table_name.replace(project_var_ref, value)
        else:
            warning(f"Variable {variable} doesn't exist")
    return table_name

def create_row(dataset, values):
    executor = SQLExecutor2(dataset=dataset)
    #Fetch column names
    column_names = [col['name'] for col in dataset.get_config()['schema']['columns']]
    column_names_quote = ['"' + col_name + '"' for col_name in column_names]
    formatted_column_names = f"({','.join(column_names_quote)})"
    
    # Format values to insert
    formatted_values = [] 
    for col in column_names:
        if col in values.keys():
            formatted_values.append(values[col])
        else:
            formatted_values.append("")
    formatted_values = tuple(formatted_values)

    table_name = get_sql_table_name(dataset) 
    table_name_quoted = f'"{table_name}"'
    # Build and run insert query
    insert_query = f"""
                    INSERT INTO {table_name_quoted} {formatted_column_names} 
                    VALUES {formatted_values};
                    """  
    executor.query_to_df(query = insert_query, post_queries=['COMMIT'])
    return

def get_row(dataset,ids):
    executor = SQLExecutor2(dataset=dataset)
    # Build condition
    condition = []
    for k,v in ids.items():
        condition.append(format_key_val(k,v))
    condition = " and ".join(condition)
    
    table_name = get_sql_table_name(dataset) 
    table_name_quoted = f'"{table_name}"'
    # Build and run select query
    select_query = f"select * FROM {table_name_quoted} WHERE {condition};"
    return executor.query_to_df(select_query)

def update_row(dataset,ids, new_values):
    executor = SQLExecutor2(dataset=dataset)
    # Build condition
    condition = []
    for k,v in ids.items():
        condition.append(format_key_val(k,v))
    condition = " and ".join(condition)
    
    # Build values to set
    values_to_set = []
    for k,v in new_values.items():
        values_to_set.append(format_key_val(k,v))
    values_to_set = ",".join(values_to_set)
    
    table_name = get_sql_table_name(dataset) 
    table_name_quoted = f'"{table_name}"'
    # Build and run update query
    update_query = f"UPDATE {table_name_quoted} SET {values_to_set} WHERE {condition};"
    executor.query_to_df(query = update_query, post_queries=['COMMIT'])
    return

def delete_row(dataset,ids):
    executor = SQLExecutor2(dataset=dataset)
    # Build condition
    condition = []
    for k,v in ids.items():
        condition.append(format_key_val(k,v))
    condition = " and ".join(condition)

    table_name = get_sql_table_name(dataset) 
    table_name_quoted = f'"{table_name}"'
    # Build and delete query
    delete_query = f"DELETE FROM {table_name_quoted} WHERE {condition};" 
    executor.query_to_df(query = delete_query, post_queries=['COMMIT'])
    return
