#######################################################################################
# AGENT DATASET MEMORY IMPLEMENTATION
#######################################################################################
import dataiku
from logging import (info, warning, error)
import json
from crud import (create_row, 
                          get_row, 
                          update_row, 
                          delete_row)

SQL_CONNECTION_NAME = "PostgreSQL" # Update to the connection you want to use (only used for creation of datasets.)

SCHEMA = {                         # Only used for the creation of the backend dataset if needed.
    'columns': [
        {'name': 'dku_conversation_id', 'type': 'string'},
        {'name': 'state', 'type': 'string'}
]} 

class DatasetMemory:
    
    MEMORY_IDS = ["dku_conversation_id"]
    
    
    def __init__(self, sql_dataset_name : str, dku_conversation_id : str):
        self.sql_dataset_name = sql_dataset_name
        self.dataset = dataiku.Dataset(sql_dataset_name)
        self.dku_conversation_id = dku_conversation_id
        
        self.init_backend()

    def init_backend(self):
        
        try:
            df = self.dataset.get_dataframe()
            info(f"Table {self.dataset.full_name} already exists : Nothing to do")
        except:
            try:
                # Write empty table.
                df = self.dataset.iter_dataframes().send(None)
                self.dataset.write_dataframe(df)
                info(f"Table {self.dataset.full_name} doesn't exists : Empty table with dataset schema was created")
            except:
                # Create dataset
                client = dataiku.api_client()
                project = client.get_default_project()
                cnx = client.get_connection(SQL_CONNECTION_NAME)
                api_dataset = project.create_sql_table_dataset(dataset_name = self.sql_dataset_name,#self.dataset.full_name, 
                                                           type=cnx.get_settings().settings["type"], 
                                                           connection=SQL_CONNECTION_NAME, 
                                                           table = f"${{projectKey}}_{self.dataset.full_name}",
                                                           schema = "")
                # Add schema to dataset
                settings = api_dataset.get_settings()
                settings.settings["schema"] = SCHEMA
                settings.save()
                
                #Create empty table
                df = self.dataset.iter_dataframes().send(None)
                self.dataset.write_dataframe(df)
                
                
                info(f"DSS Dataset {self.dataset.full_name} doesn't exists : Empty table with dataset schema was created")
                
                
    def get_state(self):
        row = get_row(self.dataset, 
                      {"dku_conversation_id" : self.dku_conversation_id})
        if not row.empty:
            return json.loads(row["state"][0])
        else:
            return {}
    
    def create_or_update_state(self, state : dict):
        df = get_row(self.dataset, {"dku_conversation_id" : self.dku_conversation_id})
        if not df.empty:
            update_row(self.dataset,{"dku_conversation_id" : self.dku_conversation_id},
                               {"state" : json.dumps(state)})
        else:
            create_row(self.dataset, 
                           {
                               "dku_conversation_id" : self.dku_conversation_id,
                               "state" : json.dumps(state)
                           }
                      )
