import dataiku
import logging
from typing import List, Dict

logger = logging.getLogger(__name__)

def web_search(search_query: str) -> List[Dict]:
    """
    Performs a Google search.
    """
    if not search_query or not isinstance(search_query, str):
        logger.warning("Empty or invalid search query provided.")
        return []

    result = []
    
    try:
        project = dataiku.api_client().get_default_project()
        web_search_tool = project.get_agent_tool("K6yKQTA")
        
        output = web_search_tool.run({
            "q": search_query
        })
        
        if output and "output" in output:
            result = output["output"]
        else:
            logger.error(f"Unexpected output format from tool: {output}")

    except Exception as e:
        logger.error(f"Error during web search for query '{search_query}': {str(e)}")

    return result

def check_order_status(order_id: str) -> str: 
    """
    Checks the status of a specific order ID.
    """
    
    return f"Order {order_id} is currently Out for Delivery. Expected arrival: Today by 5 PM."

def upgrade_subscription(tier: str) -> str:
    """
    Upgrades the user's plan to the specified tier.
    """
    
    return f"Success! The plan has been upgraded to the {tier} Tier."