# Overview

This project illustrates how Dataiku supports the design and implementation of **multi-agent systems**, using both **Visual Agents** and **Code Agents**.

Multi-agent systems rely on multiple specialized agents collaborating to solve complex tasks. Instead of a single monolithic agent, the system is structured as a set of interacting components, each with a clear responsibility. The way these agents are organized, referred to as the **agent architecture**, has a direct impact on control, scalability, debuggability, and overall system behavior.

This project focuses on **three common multi-agent architectures**:

- **Hierarchical architectures**, where a supervisor agent orchestrates specialized worker agents.
- **Network architectures**, where autonomous agents collaborate as peers.
- **Custom workflow architectures**, where agent execution follows an explicit, predefined control flow.

Each architecture is implemented using **different Python agent frameworks**, and showcased through concrete, end-to-end examples inside Dataiku DSS.

This project covers the following aspects:

- **Designing** multi-agent systems using different architectural patterns.
- **Implementing** agents using both Visual Agents and Code Agents in Dataiku.
- **Comparing** hierarchical, network, and custom workflow architectures.
- **Orchestrating** agent interactions using Python-based frameworks.

The project can be downloaded [here](https://downloads.dataiku.com/public/dss-samples/EX_ADV_AGENTS/).

# Data

This project is primarily **agent-driven**. Data is used mainly to represent **user inputs** and **shared agent memory**.

The Flow is organized around a single **Inputs** zone, which feeds both **Code-based** and **Visual-based** multi-agent systems.


# Walkthrough

The project Flow is organized into **three main zones**:

1. A common **Inputs** zone.
2. A **Code Multi-Agents** zone, showcasing three different architectures implemented in Python.
3. A **Visual Multi-Agents** zone, illustrating a hierarchical architecture built using Dataiku Visual Agents.

This layout makes it easy to compare **architectural patterns** as well as **implementation approaches** (code vs visual).

## Inputs

The **Inputs** zone provides the entry point for all agent systems.

**Key components**:

- An **[input dataset](dataset:input)** containing user prompts or requests.
- A **[memory dataset](dataset:memory_dataset_)** used by the Swarm code-based multi-agent systems.

Both downstream zones consume the same inputs, ensuring that **architectural differences, not data differences, drive behavior changes**.


## Code Multi-Agents

The **Code Multi-Agents** zone demonstrates how multi-agent architectures can be implemented using **Python-based frameworks** inside Dataiku.

This zone includes **three independent implementations**, each corresponding to a different architectural pattern.

### Hierarchical Multi-Agent Architecture (Code)

In this setup, a **Supervisor Agent** orchestrates multiple specialized agents.

**How it works**:

- The supervisor reads the user input.
- It decomposes the task into well-defined subtasks.
- Each subtask is delegated to a specialized agent.
- Agent outputs are collected and synthesized by the supervisor.

This architecture emphasizes **control, predictability, and scalability**, and is well suited for structured tasks such as report generation or analysis pipelines.


### Network (Swarm) Multi-Agent Architecture (Code)

This implementation showcases a **network-based (swarm) architecture**.

**How it works**:

- All agents are peers and share a conversational context.
- Any agent can decide to act based on the current state.
- Control flows dynamically between agents without a central coordinator.

This architecture is ideal for **open-ended or conversational tasks**, where agent autonomy and flexibility are more important than strict control.


### Custom Workflow Multi-Agent Architecture (Code)

In this setup, agent execution follows an **explicitly defined workflow**.

**How it works**:

- The input is routed through predefined steps.
- Conditional logic determines which agent is executed.
- Outputs may converge toward a final synthesis or formatting step.

This architecture provides **full traceability and deterministic behavior**, making it well suited for production-grade use cases that require auditability and consistent outputs.


## Visual Multi-Agents

The **Visual Multi-Agents** zone demonstrates how a **hierarchical multi-agent system** can be built using **Dataiku Visual Agents**, without writing orchestration code.

### Hierarchical Architecture (Visual Agents)

In this example, a **Visual Hierarchical Agent** coordinates several specialized Visual Agents:

- **Product Scout Agent** – focuses on product-related analysis.
- **Marketing Intel Agent** – analyzes marketing positioning and campaigns.
- **Sentiment Analysis Agent** – evaluates customer or market sentiment.

**How it works**:

- The input dataset feeds the Visual Hierarchical Agent.
- The hierarchical agent delegates tasks to specialized agents.
- Agent outputs are consolidated and written to an output dataset.

This implementation highlights how **agent orchestration concepts remain the same**, regardless of whether agents are built visually or in code.

## Frameworks Used

This project demonstrates how Dataiku can integrate with multiple **Python agent frameworks**, including:

- **LangGraph**, for stateful graph-based agent orchestration.
- **AutoGen**, for conversational and network-based agent interactions.
- **CrewAI**, for role-based hierarchical agent teams.
- **OpenAI Agents SDK**, for lightweight hierarchical agent delegation.
- **Google ADK**, for enterprise-grade agent development with structured workflows and modular hierarchies.
- **LlamaIndex**, for agent-based systems combining retrieval, tools, memory, and flexible orchestration patterns.

Each framework has strengths and limitations that align differently with the architectures showcased in this project.


# Next Steps: Using Your Own Use Case

The project can be downloaded [here](https://downloads.dataiku.com/public/dss-samples/EX_MULTI_AGENTS/).

## Technical Requirements

This project:

- requires **Dataiku DSS ≥ 14.2** to leverage Visual Agents and Code Agents;
- requires a **Python 3.11+ code environment** with the [following packages](article:2):
- requires a **SQL connection** for the memory_dataset.

To simplify project configuration, set this environment **at the project level**:
- Go to … **> Settings > Code env selection.**
- Choose **Select an environment** mode.
- Pick the newly created environment from the dropdown.

## How to Reuse This Project

To adapt this project to your own use case, you can:
- Replace **example user inputs** with your own prompts or business requests.
- Modify **agent roles and instructions** to reflect your domain.
- Add or remove agents depending on the required level of specialization.
- Change the **memory_dataset connection** from **filesystem to a SQL connection**.

Dataiku allows reuse at multiple levels:
- [duplicate a whole project](https://knowledge.dataiku.com/latest/getting-started/dataiku-ui/how-to-duplicate-project.html)
- [copy and paste entire subflows](https://knowledge.dataiku.com/latest/collaboration/sharing-projects-assets/how-to-copy-flow-items.html)
- copy and paste recipes and remap input/output datasets

> 📌 If you are unsure which architecture to start with, begin with the **hierarchical pattern** and evolve toward network or workflow-based designs as complexity increases.
> 

# Related Resources

- [Dataiku Documentation: Agentic AI Overview](https://doc.dataiku.com/dss/latest/agents/index.html)
- [Dataiku Documentation: Visual Agents](https://doc.dataiku.com/dss/latest/agents/introduction.html#visual-agents)
- [Dataiku Documentation: Code Agents](https://doc.dataiku.com/dss/latest/agents/introduction.html#code-agents)
- [Dataiku Developer Guide: Agents](https://developer.dataiku.com/latest/concepts-and-examples/agents.html)
- [LangGraph Documentation](https://docs.langchain.com/oss/python/langgraph/overview)
- [AutoGen Documentation](https://microsoft.github.io/autogen/0.2/)
- [CrewAI Documentation](https://docs.crewai.com/)
- [OpenAI Agents SDK Documentation](https://platform.openai.com/docs/guides/agents-sdk)
- [LlamaIndex Documentation](https://www.llamaindex.ai/)
- [Google ADK Documentation](https://google.github.io/adk-docs/)


