import dataiku
from dataiku.llm.python import BaseLLM
from dataikuapi.dss.llm import DSSLLMStreamedCompletionChunk, DSSLLMStreamedCompletionFooter

OPENAI_CONNECTION_NAME = "REPLACE_BY_YOUR_OPENAI_CONNECTION_NAME"

class MyLLM(BaseLLM):
    def __init__(self):
        pass

    def process_stream(self, query, settings, trace):
        llm = dataiku.api_client().get_default_project().get_llm(f"openai:{OPENAI_CONNECTION_NAME}:gpt-5-mini")
        completion = llm.new_completion().with_message("The user wrote this. What do you think about this question?", "system")
        for message in query["messages"]:
            if message.get("content"):
                completion = completion.with_message(message["content"], message.get("role", "user"))
        completion.settings.update(settings)

        for chunk in completion.execute_streamed():
            if isinstance(chunk, DSSLLMStreamedCompletionChunk):
                yield {"chunk": {"text": chunk.text}}
            elif isinstance(chunk, DSSLLMStreamedCompletionFooter):
                yield {"footer": chunk.data}
    