# Functional Tests
The [Dataiku Admin](project:DKUADMIN) project provides pre-configured Jupyter notebooks to automatically validate DSS funtionality.

## Containerized Notebook
This sequence of steps leverages a Python Notebook running in a Containerized execution environment.  In the case of the example `eks-default`.  But, it can just as easily be `aks-default` or `gke-default` depending upon the cloud deployment of the environment.

### Steps
1. Navigate to [2 - Functional Test - Containerized Notebook](jupyter_notebook:2 - Functional Test - Containerized Notebook)
2. Set the Jupyter Notebook to run in a Containerized Execution environment
![Notebook_Containerized_Execution.png](Wqj55XiGh63Y)
3. Verify the Jupyter Kernel is trusted and operating correctly.
![Kernel_Status.png](wSD21lTyif0U)
4. Run all code blocks in the notebook.
4. Output of the 4th block should look like this...
![CE_Output.png](V70AyvmUQWU4)

## Spark Notebook
This sequence of steps leverages a Spark Notebook running in a Containerized execution environment.  In the case of the example `eks-default`.  But, it can just as easily be `aks-default` or `gke-default` depending upon the cloud deployment of the environment.

### Steps
1. Navigate to [2 - Functional Test - Spark Notebook](jupyter_notebook:2 - Functional Test - Spark Notebook)
2. Set the Spark Notebook to run in a Containerized Execution environment

3. Verify the Jupyter Kernel is trusted and operating correctly.
![Kernel_Status.png](wSD21lTyif0U)
4. Run all code blocks in the notebook.
5. Output of the 4th block should look like this...
![CE_Output.png](V70AyvmUQWU4)
6. You can also view the Notebook pods on the cluster by Navigating to Settings -> Administration -> Clusters -> {Cluster Name} -> Monitoring.  Here's an example:
![running_kernels.png](nrKszVlj5H9K)

## Flows

The DSS Admin Project includes a flow which can be run to test DSS from the perpective of a user.
The flow includes several flow zones which can be run independently.

### Steps - Container Exec
1. Navigate to [Container Exec](flow_zone:0VwU3zN) <br/> ![SCR-20230913-hpr-2.png](UQm2ScXWoL1p)
2. Open the Python Recipe -> Advanced and ensure it's configured to run in a container <br/> ![SCR-20230913-htl-2.png](Uoi3R1yI1KCq)
3. Verify the recipe runs successfully <br/> ![SCR-20230913-hvp-2.png](FpxghARAYwJA)

### Steps - Spark
1. Navigate to the Spark Recipe[Spark Recipe](flow_zone:JFW3gio)
2. Select the Spark Recipe. <br/> ![Spark_Recipe.png](lygrujXF75yM)
3. Ensure the Engine is set to Spark. <br/>
4. Verify the recipe runs successfully <br/> **NOTE: The performance warnings are expected in this test because the output is written to in a non-distributed way. This is used in this test for simplicy but should not be replicated in production Spark jobs** ![SCR-20230913-hz8-2.png](7xuVGY63b8e0)

![Engine_Spark.png](c6sQUut1AOS8)

## Containerized Webapp
The DSS Admin Project includes a pre-built web application to validate backends can be successfully started in containers.

### Steps
1. Open the [Containerized Webapp Test](web_app:SmwHsTi) webapp
2. Navigate to Settings -> Settings  and select the `webapp` container configuration <br/> ![SCR-20230913-je0-2.png](EFZkkCsb29uS)
3. Start the Webapp backend and verify it previews successfully <br/> ![SCR-20230913-jgv-2.png](ogI2q1aLhVQh)

## API Service
The DSS Admin Project includes a pre-built API service to validate that API services can be deployed to an Elastic AI infrastructure.

**NOTE: You will need to ensure that the Local Deployer -> API Deployer service is configured with an Infrastructure target.  This will most likely be an Elastic AI cluster, but can also be API Node(s) as well.**
![API_Infrastructure.png](CtP4gOGL1dvo)

### Steps
1. Navigate to the validation API Service [dataiku-api-validation](lambda_service:dataiku-api-validation)
  - or Project Settings -> API Designer
  ![API_Designer.png](SMqNjXzBtBn9)
  - and then the `dataiku-api-validation` API Service
  ![Validation_API.png](PHH9YZbZ0FDT)
2. Select Publish on Deployer and Select `OK`
![Publish_on_Deployer.png](tnQgbnAZDmzj)
3. Publish a version on Deployer and select `OK`
![Publish_version_on_Deployer.png](d1jsnkAve0zY)
4. Navigate to the `Local Deployer` or, if applicable,  `Remote Deployer`
![Local_Deployer.png](b1VpwfjM5gCs)
5. Select `API Services`
![API_Deployer.png](Qso90zMZg49d)
6. Deploy the validation API by selecting `Deploy`
![Deploy_Validation_API.png](YooIyW3iNlK2)
7. Create a New Deployment and select `Deploy`
![New_Deployment.png](k7CMf4qRGRuf)
8. Select `Deploy`
![Ready_to_Deploy.png](uk7vKZnStOBo)
9. Validate the deployed API Service
![Deployed_API_Service.png](DqkMZFS2kcmS)
  - (1) Deployment name
  - (2) Deployment version
  - (3) Kubernetes deployment name
10. You can view the sample code for testing if you wish, but trying to run `Run and test` will most likely fail unless you first take steps to expose the API service via the various Kubernetes exposition types e.g. Load Balance, Ingress, Node Port, etc.
![Sample_Code.png](pqNqtMowONwj)
  