# -*- coding: utf-8 -*-
import dataiku
import io
import os
import pdf2image

folder_source = dataiku.Folder("cFWXLXKE")
folder_destination = dataiku.Folder("FAUwCSvY")

# Loop through each file in the source folder
for file in folder_source.list_paths_in_partition():
    if file.endswith(".pdf"):  # Process only PDF files
        with folder_source.get_download_stream(file) as stream:
            # Read the PDF content as bytes
            pdf_bytes = stream.read()

            # Convert the first page of the PDF to an image
            images = pdf2image.convert_from_bytes(pdf_bytes)[0]

            # Remove the '.pdf' extension from the filename
            filename_without_extension = os.path.splitext(file)[0]

            # Create a new filename with the '.jpg' extension
            new_filename = f"{filename_without_extension}.jpg"

            # Save the image in JPEG format into an in-memory buffer
            with io.BytesIO() as buf:
                images.save(buf, format="JPEG")

                # Upload the JPEG image to the destination folder
                folder_destination.upload_data(new_filename, buf.getvalue())
