# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd

folder = dataiku.Folder("sr6n0lYE")

files = {"path": [], "prediction": []}
for path in folder.list_paths_in_partition():
    files["path"].append(path[:-5])
    with folder.get_download_stream(path) as f:
        files["prediction"].append(f.read().decode("utf-8"))

df = pd.DataFrame.from_dict(files)
dataiku.Dataset("annotated_images").write_with_schema(df)