# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Create a synthetic time series dataset
np.random.seed(42)
n_samples = 1000
time = np.arange(n_samples)
feature1 = 0.5 * np.sin(0.2 * time)
feature2 = 0.8 * np.cos(0.1 * time)
feature3 = np.random.normal(0, 1, n_samples)
output1 = 2 * feature1 + 1.5 * feature2 + 0.5 * feature3 + np.random.normal(0, 0.5, n_samples)
output2 = 1.5 * feature1 - 0.8 * feature2 + 0.3 * feature3 + np.random.normal(0, 0.5, n_samples)

# Create a DataFrame
df = pd.DataFrame({'datetime': pd.date_range('2023-01-01', periods=n_samples, freq='D'),
                     'feature1': feature1, 'feature2': feature2, 'feature3': feature3,
                     'output1': output1, 'output2': output2})

# Write recipe outputs
generated_data = dataiku.Dataset("input-keras_multioutput_regression")
generated_data.write_with_schema(df)
