# Amazon Translation[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

## This plugin provides a recipe to use Amazon Translation to translate text[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

|  |  |

| --- | --- |

| Version | 1.0.3 |

| Author | Dataiku (Niklas MUENNIGHOFF, Mehdi HAMOUMI) |

| Released | 2021-06 |

| Last updated | 2022-11 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

This plugin lets you translate text to another language using Amazon Translation.

Note that the Amazon Translation API is a paid service, check their API pricing page for more information.

## How to set up[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

If you are a Dataiku and AWS (Amazon Web Services) admin user, follow these configuration steps right after you install the plugin. If you are not an admin, you can forward this to your admin and scroll down to the **How to use** section.

### 1. Create a privileged IAM User for Amazon Translation in the AWS Console[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

In order to use the Amazon Translation API, you need an AWS account. If you don’t have one yet, you can sign up for the free tier here.

Next, you need to create credentials with the necessary permissions using AWS Identity and Access Management (IAM). If you don’t have an IAM user yet, create one first:

Next, grant the user access to Amazon Translate by giving them privileges directly, or by assigning them to a group.

Make sure to take note of the Access key ID & Secret access key which will appear after creation. Once you have an IAM user with the necessary privileges, you just need to provide DSS with the credentials.

### 2. Create an API configuration preset – in Dataiku DSS[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

In Dataiku DSS, navigate to the Plugin page > Settings > API configuration and create your first preset.

### 3. Configure the preset – in Dataiku DSS[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

* **Fill the AUTHENTICATION settings**

+ Enter your AWS Access key id & AWS secret access key in the corresponding fields. Leave the session token empty if you don’t have one. Next choose a region from the AWS availability regions.

+ Alternatively, you may leave the fields empty so that the credentials are ascertained from the server environment. If you choose this option, please make sure the credentials are defined in the environment such as via a .bashrc file. Note that this option will not work in a User Isolation Framework (UIF) setup.

* **(Optional) Review the PARALLELIZATION and ATTEMPTS settings**

+ The default *Concurrency* parameter means that 4 threads will call the API in parallel.

- We do not recommend changing this default parameter unless your server has a much higher number of CPU cores.

+ The default *Maximum Attempts* means that if an API request fails, it will be tried another 3 times.

- Regardless of why the request fails (e.g. an access error with your AWS account or a throttling exception due to too many concurrent requests), it will be tried again.

- Note that AWS may charge you depending on the nature of the error, for each additional attempt.

* **Set the Permissions of your preset**

+ You can declare yourself as the Owner of this preset and make it available to everybody, or to a specific group of users.

+ Any user belonging to one of these groups on your Dataiku DSS instance will be able to see and use this preset.

Voilà! Your preset is ready to be used.

Later, you (or another Dataiku admin) will be able to add more presets. This can be useful to segment plugin usage by user group. For instance, you can create a “Default” preset for everyone and a “High performance” one for your Marketing team, with separate billing for each team.

## How to use[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

Let’s assume that you have installed this plugin and that you have a Dataiku DSS project with a dataset containing a column of text to translate.

### Input[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

* **Dataset with a text column to translate**

### Amazon Translation recipe[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

To create your first recipe, navigate to the Flow, click on the **+ RECIPE** button and access the **Natural Language Processing** menu. If your dataset is selected, you can directly find the plugin in the right panel.

#### Settings[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

* **Review INPUT parameters**

+ The *Text column* parameter is the column in the input dataset that you wish to translate.

+ The *Source language* parameter is the original language of the *Text column* . If you would like the translation api to infer the original language, you can select the Auto-detect option.

- Find the available *Source and Target languages* here.

+ The *Target language* parameter is the language you would like to translate to.

* **Review CONFIGURATION parameters**

+ The *Preset* parameter is automatically filled by the default one made available by your Dataiku admin. You may select another one if multiple presets have been created.

+ The *Fail on error*parameter lets you choose if the recipe should abort execution if any issues are raised. If unchecked, any errors will be logged in two additional columns in the output.

#### Output[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

* **Dataset with text translated to another language**

The columns of the output dataset are as follows:

* [Input dataset columns]

+ All columns from the input dataset will be preserved

* [selected column]\_{target iso code}

+ The selected column in its translated version

* translation\_api\_response

+ Raw API response in JSON form

* translation\_api\_error\_message

+ The error message in case an error occurred

+ Only present if *Fail on error* is not selected during configuration

* translation\_api\_error\_type

+ The error type in case an error occurred

+ Only present if *Fail on error* is not selected during configuration

Happy natural language processing!

##### Install In DSS[¶](https://www.dataiku.com/product/plugins/nlp-amazon-translation/)

To install the plugin, open the  Apps menu, click Plugins and search for Amazon Translation.

Alternatively, you can download a zipped version here.
