# Genetic algorithm for feature engineering[¶](https://www.dataiku.com/product/plugins/feature-generation-genetic-algorithms/)

## This plugin provides recipes to create and select features with a genetic algorithm based on the DEAP framework[¶](https://www.dataiku.com/product/plugins/feature-generation-genetic-algorithms/)

Genetic Algorithms are inspired by the concepts of evolution through natural selection. They are often used in high dimensional spaces where grid / random search would be prohibitive.

Genetic Algorithms encode the space to explore with genes and proceed by generations. For each generation:

* individuals forming the current population are evaluated (fitness)

* the best individuals are chosen to mix their genes together (crossover)

* independent random changes are performed (mutation)

This plugins deals with feature creation and selection, powered by genetic algorithms. Starting from a dataset with features and a target, it will automatically select among features both from the dataset and their combinations (product, sum and differences). In this setting, an individual is represented by a boolean array with a value for every feature (originals and combinations) indicating whether it is selected or not as an input for the model to train.

## Plugin Information[¶](https://www.dataiku.com/product/plugins/feature-generation-genetic-algorithms/)

|  |  |

| --- | --- |

| Version | 0.0.2 |

| Author | Dataiku |

| Released | 2018-08-01 |

| Last updated | 2018-08-01 |

| License | LGPL v3.0 |

| Source code | Github |

| Reporting issues | Github |

### Install In DSS[¶](https://www.dataiku.com/product/plugins/feature-generation-genetic-algorithms/)

To install the plugin, open the  Apps menu, click Plugins and search for Genetic Algorithms.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/feature-generation-genetic-algorithms/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
