# Image-annotations-to-dataset[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

## Start using DSS computer vision feature on your datasets by using Convert object detection annotations recipe ![¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

|  |  |

| --- | --- |

| Version | 1.0.0 |

| Author | Dataiku (Claire BEHUE) |

| Released | 2021-11 |

| Last updated | 2021-11 |

| License | Apache Software License |

| Source code | Github repository |

| Reporting issues | Github issues |

With this plugin, you will be able to:

* Convert image annotations into a dataset compatible with object detection in DSS

## How to set up[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

Just install the plugin, no specific code environment is required.

## How to use[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

Let’s assume that you have a Dataiku DSS project with a folder containing images & annotations in COCO or Pascal VOC format

To create your first recipe, navigate to the Flow, click on the **+ RECIPE** button and access the recipe from there. If your folder is selected, you can directly find the plugin on the right panel.

### *Convert object detection annotations recipe*[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

#### Input[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

* **A folder with images and object detection annotations under COCO or Pascal VOC.**

#### Output[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

* **A dataset with two columns : images\_annotations & images\_path, compatible with object detection in DSS.**

#### Settings[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

The settings modal lets you choose first the input format (see official documentations to know which format match your data : **COCO or Pascal VOC**).

##### Images Folder[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

For both formats you need to enter the path to the subfolder containing your images. The image folder path must be relative to the managed folder root and can be left empty if the images files are directly at the root of your managed folder.    Example: ‘B/’ if your managed folder contains a subfolder B which contains the images.

##### Annotations file path (COCO)[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

Coco annotations are all stored into a single JSON file, you must specify the relative path to this file from your managed folder root. This path must include the file name and be relative to the managed folder root.    Example: ‘annotations/\_annotations.coco.json’ if your managed folder contains a subfolder ‘annotations’ which contains your annotations file.

##### Annotations folder (Pascal VOC)[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

For Pascal VOC, annotations are split into different files: one XML file for each image. You must specify the path of the subfolder containing these XML files. This annotation folder path must be relative to the managed folder root and can be left empty if your annotations files are directly at the root of your managed folder.    Example: ‘Annotations/’ if your managed folder contains a subfolder Annotations which contains the XML annotations files.    Note: from Pascal VOC documentation “The top-left pixel in the image has coordinates (1,1)”. Running this recipe will remove this offset to be compliant with DSS.

##### Install In DSS[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

To install the plugin, open the  Apps menu, click Plugins and search for image-annotations-to-dataset.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/image-annotations-to-dataset/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
