# Linkedin Marketing[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

## Retrieve Data about your LinkedIn campaigns[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

|  |  |

| --- | --- |

| Version | 0.0.4 |

| Author | Dataiku (Marine SOBAS) |

| Released | 2020-11 |

| Last updated | 2021-02 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github issues |

This Dataiku DSS plugin retrieves information and metrics about LinkedIn’s campaigns using LinkedIn Marketing Developper platform.

## How to set up[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

### 1. Create a LinkedIn app[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

* First, go to LinkedIn developper’s app creation page. There, select your company, upload a logo, agree to the terms and save.

* In the **Auth** tab, make note of the app’s client ID and client secret.

* Add the callback URL. This URL has to follow this model: `https://{your instance domain:port number}/dip/api/oauth2-callback`

* In the **Products** tab, select the **Marketing Developer Platform**. This authorization can take more than a day to be granted. Once it is, you should see `r_ads` and `r_ads_reporting` appear in the list of available scopes.

### 2. Retrieve an access token[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

Follow the steps described in this Authorization Code Flow to create and retrieve an access token.

### 3. Create a preset[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

Create and name a preset in **DSS App > Plugins > Installed > LinkedIn Marketing > Settings > Access token > +Add preset**. Paste the access token retrieved from step 2 and save the preset

## How to use[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

Find you account(s) ID(s)

Several datasets are created by the plugin. To retrieve all of them, the account should contain at least one campaign and one creative. The datasets are :

* **Campaign groups output**: Categories of campaigns. In fact, campaigns are often sorted by country or by topics (France/ Partners..). Read more about campaign groups.

* **Campaigns output**: Returns the names of the campaigns, their targeting, budget… Read more about campaigns.

* **Creatives output**: Returns information about the existing creatives such as their status (active, paused..), their types.. Read more about creatives.

* **Campaigns’ metrics**: daily metrics (impressions, conversions, cost) at a campaign level. Read more about campaign metrics.

* **Creatives’ metrics**: daily metrics (impressions, conversions, cost) at a creative level. Read more about creative metrics.

### Install In DSS[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

To install the plugin, open the  Apps menu, click Plugins and search for linkedin-marketing.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/linkedin-marketing/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
