# Tableau Extension – Dataiku AutoML Insights[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

## This Tableau Extension allows training DSS models from a Tableau dashboard to identify patterns, rank variables by importance, and analyze features in your data[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Tableau is one of the leading data visualisation tools and a Dataiku partner.

This extension improves data analysis by leveraging Dataiku DSS’s powerful automated Visual ML capabilities in order to reveal key data insights and direct further investigation.  A Demo version of the Dataiku AutoML Insights Extension is available for free on the Tableau Extension Gallery.  Usage of the complete version of the Extension requires a paid DSS license.

If you are an existing Dataiku customer please reach out to your customer success manager for access to a full version of the Dataiku AutoML Insights Extension.  If you are not a current Dataiku customer, you can explore our license options here: https://www.dataiku.com/product/get-started/ . To contact us please visit the Contact Us page and fill out a general inquiry form and a member of our team will be in touch.

**The following algorithms are available for training with the extension:**

* Random Forest

* Gradient Boosted Trees

* Decision Tree

* XGBoost

* Extra Random Trees

* For additional models we recommend using Dataiku DSS’s built in automated Visual ML which provides a more complete set of algorithms, AutoML, and more control over training settings: https://doc.dataiku.com/dss/latest/machine-learning/index.html

**Data Limitations:**

All data used within your Tableau Worksheet is sent. Data can be reduced using Tableau Data Source filters.  For analysis of larger datasets, we recommend using Dataiku DSS where users can attach compute resources to handle big data.  Dataiku DSS can also provided deeper analysis, deployment of models, and many other use cases.  Dataiku AutoML Insights does not support formatted values and will instead read in the raw value format of data sent to Dataiku DSS for training.  Additionally, the Extension does not, at this time, support dates or geospatial data for training.

## Extension Information[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

|  |  |

| --- | --- |

| Version | 1.0 |

| Author | Dataiku |

| Released | 2020-09 |

| Last updated | 2020-09 |

| License | Apache Software License |

## Requirements[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Any Dataiku user that has a Tableau License can use the Dataiku Extension for Tableau. Dataiku customers will need DSS 8.0 and higher as well as Python 3.6 or Python 3.7. Please note Tableau extensions are available in Tableau 2018.2 or newer versions. For more information about using extensions in Tableau, please see https://www.tableau.com/developer/extensions.

## How To Use[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

The Extension can be directly added to a Tableau dashboard.  If you are using the demo version of the Extension, DSS settings do not need to be configured.

### Configuring DSS Settings[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Identify the host and port where your application is running.  The admin who installed the extension will be able to provide you this information from the .trex file.  Input your DSS API key and user (this can be retrieved from a DSS admin or created yourself under **Profile & Settings > API Keys**.  API keys must have permission to create a project):

**Note: The extension allows you to save your API key with the Tableau workbook so you don’t have to re-enter it each time you open the workbook.**

### Generating Insights[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Select your desired input data worksheet, column to explain, and algorithm(s) to train from the dropdown.  Filters can be applied to the input data,

Click generate insights and allow the Extension time to send the data, train models, and return insights to your dashboard (training can be aborted using the Abort button),

Once your insights have been generated you can switch between models using the dropdown.

The available insights are:

* The features importance chart: Display the weights given by the model after training.

* The feature analysis chart: Display the average aggregation over target variable with respect to the rest of the columns.

* The model metrics: Provide standard scoring values

* The model information: Relevant information on the model or the training dataset

## Understanding Error Messages[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

There are no limits to the combination of inputs you can provide the Extension to generate insights but not all combinations will result in the same insights.

### Features Analysis Error[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

If you have selected a Column to Explain that includes Categorical Data, Feature Analysis charts cannot be created and you will receive the following error (Feature Analysis is compatible with Numerical Data),

Further details on how Dataiku DSS handles features can be found here: https://doc.dataiku.com/dss/latest/machine-learning/features-handling/index.html

### Long Loading Time[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

The Dataiku AutoML Insights is robust in handling larger datasets and varied data.  However, if you find training taking a long time with large datasets and/or more complex algorithms we suggest that you move to Dataiku DSS for improved training performance and control in these situations.  Insight generation can also always be aborted during training.

#### Download the Extension[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Head to the Tableau Extension Gallery to download the Dataiku AutoML Insights Extension

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/tableau-extension-dataiku-automl-insights/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
