# Thread[¶](https://www.dataiku.com/product/plugins/thread/)

## THREAD™ together your Dataiku datasets and created definitions to formalize a catalog for improved understanding and governance. A free, lightweight cataloging tool, THREAD™ ties together your data lineage and provides a single location to document data connected to Dataiku. Create efficiency and maximize your data with THREAD™.[¶](https://www.dataiku.com/product/plugins/thread/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/thread/)

|  |  |

| --- | --- |

| Version | 1.1.4 |

| Author | Snow Fox Data |

| Released | 2022-09-01 |

| Last updated | 2022-11-10 |

| License | Commons Clause / GPL-3.0 License |

| Source code | Github |

| Reporting issues | Snow Fox Data support |

## Introduction[¶](https://www.dataiku.com/product/plugins/thread/)

At Snow Fox Data, we specialize in understanding the unique challenges our customers have throughout their data journey. We are committed to understanding these challenges and finding the right solution to set them up for success. Time and again, we heard clients express challenges with documenting data and viewing upstream/downstream data lineage. **Clients like you asked for help, and we delivered**.

With the growing need for a better cataloging and lineage tool, Snow Fox Data created THREAD™, a free Dataiku plugin which integrates directly with Dataiku and its datasets. THREAD™ ties together your data lineage while freeing you from home grown cataloging and enterprise data lineage tools which can be labor intensive and cost prohibitive. Through this tool, our customers have gained efficiencies, visibility, governance, cost savings, and deeper trust in the data that helps drive their business decisions.

Are you challenged to find the right data cataloging tool for your business? See what our THREAD™ plugin can do for you:

### Create Efficiences[¶](https://www.dataiku.com/product/plugins/thread/)

* Saves time with access to the data definition at the time and location the information is needed.

* Improved insights during exploratory data analysis through better documented columns.

* Faster solution building and data enrichment through documentation and improved data understanding.

### Improve Governance[¶](https://www.dataiku.com/product/plugins/thread/)

* Clear measurement of governance through KPIs showing the percent of columns documented in any data set.

* Repository for data documentation

* Easy to keep definitions up to date

* Allows definitions to be easily audited (exportable)

* Integrated with Dataiku permissions that limit editing data definitions to those with access

### Improve Trust[¶](https://www.dataiku.com/product/plugins/thread/)

* Easy transparency for data analysts, data engineers, data scientists, and business leaders to see:

* What data was used in a project (data catalog).

* Where it was used (upstream/downstream data lineage).

* How that data is defined throughout the project (data dictionary).

* Builds a common language between the business and analysts

### Training & Onboarding Efficiencies[¶](https://www.dataiku.com/product/plugins/thread/)

* Help new team members learn company-specific jargon and abbreviations quickly

* Streamline onboarding and training by using one platform (Dataiku) instead of multiple spreadsheets and code documentation.

### Cost Savings[¶](https://www.dataiku.com/product/plugins/thread/)

* Proven to saves Analytics leaders $200k+ in purchasing, implementing, and supporting an enterprise grade data catalog & data lineage tool for their Dataiku environment.

## How to set up[¶](https://www.dataiku.com/product/plugins/thread/)

Our team at Snow Fox Data has created everything you need to get started. Refer to the installation instructions at https://www.snowfoxdata.com/thread-plugin

## How to use[¶](https://www.dataiku.com/product/plugins/thread/)

We are happy to provide additional resources and information to help make this plugin a success for you. Refer to the usage instructions at https://www.snowfoxdata.com/thread-plugin

## Plugin support policy[¶](https://www.dataiku.com/product/plugins/thread/)

Support issues can be submitted on the Github repository at:

https://github.com/Excelion-Partners/dss-thread/issues

More support options are available by contacting the Snow Fox Data team at [email protected]

### Install In DSS[¶](https://www.dataiku.com/product/plugins/thread/)

To install the plugin, open the  Apps menu, click Plugins and search for Thread.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/thread/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
