# Webapps[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#webapps "Permalink to this heading")

The webapps API can control all aspects of managing a webapp.

## Example use cases[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#example-use-cases "Permalink to this heading")

In all examples, project is a `dataikuapi.dss.project.DSSProject` handle, obtained using client.get\_project() or client.get\_default\_project()

### List the webapps of a project and get a handle for the first one[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#list-the-webapps-of-a-project-and-get-a-handle-for-the-first-one "Permalink to this heading")

By default, `list\_webapps()` returns a list of dict items describing the webapps of a project. From the dict item, the `dataikuAPI.dss.webapp.DSSWebApp` handle can be obtained using the `to\_webapp()` method. Documentation of the `list\_webapps()` and `get\_webapp()` methods can be found in the API projects documentation.

§ project\_webapps = project.list\_webapps()

§ my\_webapp\_dict = project\_webapps[0]

§ print("Webapp name : %s" % my\_webapp\_dict["name"])

§ print("Webapp id : %s" % my\_webapp\_dict["id"])

§ my\_webapp = project\_webapps[0].to\_webapp()

### Get a webapp by id, check if the webapp is running and if not, start it[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#get-a-webapp-by-id-check-if-the-webapp-is-running-and-if-not-start-it "Permalink to this heading")

A handle to a webapps state `dataikuAPI.dss.webapp.DSSWebAppBackendState` object can be obtained using the `get\_state()` method.

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ if (not my\_webapp.get\_state().running):

§ my\_webapp.start\_or\_restart\_backend()

### Stop a webapp backend[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#stop-a-webapp-backend "Permalink to this heading")

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ my\_webapp.stop\_backend()

### Get the settings of a webapp to change its name[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#get-the-settings-of-a-webapp-to-change-its-name "Permalink to this heading")

A handle to a webapps settings `dataikuAPI.dss.webapp.DSSWebAppSettings` object can be obtained using the `get\_settings()` method.

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ settings = my\_webapp.get\_settings()

§ print("Current webapp name : %s" % settings.data["name"])

§ settings.data["name"] = "new webapp name"

§ print("New webapp name : %s" % settings.data["name"])

§ settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/webapps.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.webapp` |  |
