# Wikis[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#wikis "Permalink to this heading")

You can interact with the Wiki of each project through the API.

## Getting the DSSWiki object[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#getting-the-dsswiki-object "Permalink to this heading")

You must first retrieve the `DSSWiki` through the `get\_wiki()` method

§ project = client.get\_project("MYPROJECT")

§ wiki = project.get\_wiki()

## Retrieving and modifying the content of an article[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#retrieving-and-modifying-the-content-of-an-article "Permalink to this heading")

§ article = wiki.get\_article("article\_name")

§ article\_data = article.get\_data()

§ # Modify the content of the article data

§ current\_markdown\_content = article\_data.get\_body()

§ article\_data.set\_body("# My new Markdown content")

§ # And save the modified content

§ article\_data.save()

## Deleting an article[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#deleting-an-article "Permalink to this heading")

§ article = wiki.get\_article("article\_name")

§ article.delete()

## Getting the list of all articles[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#getting-the-list-of-all-articles "Permalink to this heading")

This prints the content of all articles in the Wiki

§ for article in wiki.list\_articles():

§ print("Article: %s" % article.article\_id)

§ article\_data = article.get\_data()

§ print("Content:")

§ print(article\_data.get\_body())

## Uploading an attachment to an article[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#uploading-an-attachment-to-an-article "Permalink to this heading")

After upload, the attachment can be referenced through the Markdown syntax

§ article = wiki.get\_article("article\_name")

§ with open("myimage.jpg") as f:

§ article.upload\_attachment(f, "myimage.jpg")

## Moving an article in the taxonomy[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#moving-an-article-in-the-taxonomy "Permalink to this heading")

You can change the parent of an article

§ settings = wiki.get\_settings()

§ settings.move\_article\_in\_taxonomy("article\_name", "new\_parent\_of\_the\_article")

§ settings.save()

## Changing the home article of the wiki[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#changing-the-home-article-of-the-wiki "Permalink to this heading")

§ settings = wiki.get\_settings()

§ settings.set\_home\_article\_id("new\_home\_article")

§ settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/wiki.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.wiki.DSSWiki`(client, project\_key) | A handle to manage the wiki of a project |

| `dataikuapi.dss.wiki.DSSWikiSettings`(client, ...) | Global settings for the wiki, including taxonomy. |

| `dataikuapi.dss.wiki.DSSWikiArticle`(client, ...) | A handle to manage an article |

| `dataikuapi.dss.wiki.DSSWikiArticleData`(...) | A handle to manage an article |
