# Administration[¶](https://developer.dataiku.com/latest/concepts-and-examples/administration.html#administration "Permalink to this heading")

Here are some more global administration tasks that can be performed using the DSS Public API:

* Reading and writing general instance settings

* Managing user and group impersonation rules for User Isolation Framework

* Managing (creating/modifying) code environments

* Managing instance variables

* Listing long-running tasks, getting their status, aborting them

* Listing running notebooks, getting their status, unloading them

* Managing global API keys

* Listing global DSS usages (projects, datasets, recipes, scenarios…)

* Managing personal API keys

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/administration.html#detailed-examples "Permalink to this heading")

This section contains more advanced examples on administration tasks.

### List running Jupyter notebooks[¶](https://developer.dataiku.com/latest/concepts-and-examples/administration.html#list-running-jupyter-notebooks "Permalink to this heading")

You can use `dataikuapi.dss.project.DSSProject.list\_jupyter\_notebooks()` to retrieve a list of notebooks for a given Project, along with useful metadata.

§ import pprint

§ import dataiku

§ def get\_instance\_notebooks(client):

§ all\_notebooks = dict()

§ for p in client.list\_projects():

§ p\_key = p["projectKey"]

§ project = client.get\_project(p\_key)

§ project\_notebooks = project.list\_jupyter\_notebooks()

§ if project\_notebooks:

§ notebooks = []

§ for nb in project\_notebooks:

§ # If the notebook is active then it has at least 1 running session

§ sessions = nb.get\_sessions()

§ if sessions:

§ status = "ACTIVE - {} session(s)".format(len(sessions))

§ else:

§ status = "INACTIVE"

§ notebooks.append({"name": nb.notebook\_name,

§ "status": status})

§ all\_notebooks[p\_key] = notebooks

§ return all\_notebooks

§ def pprint\_instance\_notebooks(client):

§ all\_notebooks = get\_instance\_notebooks(client)

§ pprint.pprint(all\_notebooks)

§ client = dataiku.api\_client()

§ pprint\_instance\_notebooks(client)

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/administration.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.admin.DSSGeneralSettings`(client) | The general settings of the DSS instance. |

| `dataikuapi.dss.admin.DSSUserImpersonationRule`([raw]) | Helper to build user-level rule items for the impersonation settings |

| `dataikuapi.dss.admin.DSSGroupImpersonationRule`([raw]) | Helper to build group-level rule items for the impersonation settings |

| `dataikuapi.dss.admin.DSSInstanceVariables`(...) | Dict containing the instance variables. |

| `dataikuapi.dss.future.DSSFuture`(client, job\_id) | A future on the DSS instance |

| `dataikuapi.dss.notebook.DSSNotebook`(client, ...) | Deprecated. |

| `dataikuapi.dss.admin.DSSGlobalApiKey`(client, key) | A global API key on the DSS instance |

| `dataikuapi.dss.admin.DSSGlobalUsageSummary`(data) | The summary of the usage of the DSS instance. |

| `dataikuapi.dss.admin.DSSPersonalApiKey`(...) | A personal API key on the DSS instance. |

| `dataikuapi.dss.admin.DSSPersonalApiKeyListItem`(...) | An item in a list of personal API key. |
