# Client[¶](https://developer.dataiku.com/latest/concepts-and-examples/client.html#client "Permalink to this heading")

The REST API Python client makes it easy to write client programs for the DSS REST API in Python. The REST API Python client is in the `dataikuapi` Python package.

The client is the entry point for many of the capabilities listed in this chapter.

For more details about the two Dataiku packages, see Getting started, Using the APIs inside of DSS and Using the APIs outside of DSS.

## Creating a client from inside DSS[¶](https://developer.dataiku.com/latest/concepts-and-examples/client.html#creating-a-client-from-inside-dss "Permalink to this heading")

To work with the API, a connection needs to be established with DSS, by creating a `DSSClient` object. Once the connection is established, the `DSSClient` object serves as the entry point to the other calls.

The Python client can be used from inside DSS. In that case:

* It’s preinstalled, you don’t need to do anything

* You don’t need to provide any API key, as the API client will automatically inherit connection credentials from the current context

§ import dataiku

§ client = dataiku.api\_client()

§ # client is now a DSSClient and can perform all authorized actions.

§ # For example, list the project keys for which you have access

§ client.list\_project\_keys()

## Creating a client from outside DSS[¶](https://developer.dataiku.com/latest/concepts-and-examples/client.html#creating-a-client-from-outside-dss "Permalink to this heading")

To work with the API, a connection needs to be established with DSS, by creating a `DSSClient` object. Once the connection is established, the `DSSClient` object serves as the entry point to the other calls.

When running outside of DSS, you’ll first need to install the client. For that, simply install it from pip

To use the Python client from outside DSS, simply install it from pip.

§ pip install dataiku-api-client

This installs the client in the system-wide Python installation, so if you are not using virtualenv, you may need to replace `pip` by `sudo pip`.

Note that this will always install the latest version of the API client. You might need to request a version compatible with your version of DSS.

When connecting from the outside world, you need an API key. See Public API Keys for more information on how to create an API key and the associated privileges.

You also need to connect using the base URL of your DSS instance.

§ import dataikuapi

§ host = "http://localhost:11200"

§ apiKey = "some\_key"

§ client = dataikuapi.DSSClient(host, apiKey)

§ # client is now a DSSClient and can perform all authorized actions.

§ # For example, list the project keys for which the API key has access

§ client.list\_project\_keys()

### Disabling SSL certificate check[¶](https://developer.dataiku.com/latest/concepts-and-examples/client.html#disabling-ssl-certificate-check "Permalink to this heading")

If your DSS has SSL enabled, the package will verify the certificate. In order for this to work, you may need to add the root authority that signed the DSS SSL certificate to your local trust store. Please refer to your OS or Python manual for instructions.

If this is not possible, you can also disable checking the SSL certificate by setting `client.\_session.verify = False`

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/client.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dssclient.DSSClient`(host[, ...]) | Entry point for the DSS API client |

| `dataikuapi.dssclient.TemporaryImportHandle`(...) |  |
