# Feature Store[¶](https://developer.dataiku.com/latest/concepts-and-examples/feature-store.html#feature-store "Permalink to this heading")

The public API allows you to:

* list feature groups `dataikuapi.dss.feature\_store.DSSFeatureStore.list\_feature\_groups()`

* check if a dataset is a feature group `dataikuapi.dss.dataset.DSSDatasetSettings.is\_feature\_group()`

* set/unset a dataset as a feature group: `dataikuapi.dss.dataset.DSSDatasetSettings.set\_feature\_group()`

See Feature Store for more information.

## Listing feature groups[¶](https://developer.dataiku.com/latest/concepts-and-examples/feature-store.html#listing-feature-groups "Permalink to this heading")

§ import dataiku

§ # if using API from inside DSS

§ client = dataiku.api\_client()

§ feature\_store = client.get\_feature\_store()

§ feature\_groups = feature\_store.list\_feature\_groups()

§ for feature\_group in feature\_groups:

§ print("{}".format(feature\_group.id))

Note

This will only display feature groups of projects on which the user has at least read permission

Note

Because of indexing latency, you have have to wait a few seconds before newly defined feature groups are visible

## (Un)setting a dataset as a Feature Group[¶](https://developer.dataiku.com/latest/concepts-and-examples/feature-store.html#un-setting-a-dataset-as-a-feature-group "Permalink to this heading")

§ import dataiku

§ # if using API from inside DSS

§ client = dataiku.api\_client()

§ project = client.get\_project('PROJECT\_ID')

§ ds = project.get\_dataset('DATASET\_ID')

§ ds\_settings = ds.get\_settings()

§ # pass False to undefine as Feature Group

§ ds\_settings.set\_feature\_group(True)

§ ds\_settings.save()

### Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/feature-store.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.feature\_store.DSSFeatureStore`(client) |  |

| `dataikuapi.dss.feature\_store.DSSFeatureGroupListItem`(...) |  |
