# Fleet Manager Instances[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fminstances.html#fleet-manager-instances "Permalink to this heading")

Instances are the DSS instances that Fleet Manager will manage.

## Create an instance[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fminstances.html#create-an-instance "Permalink to this heading")

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ # <Cloud vendor> is either AWS, Azure or GCP

§ client = dataikuapi.FMClient<Cloud vendor>("https://localhost", key\_id, key\_secret)

§ my\_template\_id = "ist-default"

§ my\_network\_id = "vn-default"

§ # create an instance

§ creator = client.new\_instance\_creator("My new designer", my\_template\_id, my\_network\_id, "dss-11.0.3-default")

§ dss = creator.create()

§ # provision the instance

§ status = dss.reprovision()

§ res = status.wait\_for\_result()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fminstances.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.fm.instances.FMInstance`(client, ...) | A handle to interact with a DSS instance. |

| `dataikuapi.fm.instances.FMInstanceCreator`(...) |  |

| `dataikuapi.fm.instances.FMAWSInstance`(...) |  |

| `dataikuapi.fm.instances.FMAWSInstanceCreator`(...) |  |

| `dataikuapi.fm.instances.FMAzureInstance`(...) |  |

| `dataikuapi.fm.instances.FMAzureInstanceCreator`(...) |  |

| `dataikuapi.fm.instances.FMGCPInstance`(...) |  |

| `dataikuapi.fm.instances.FMGCPInstanceCreator`(...) |  |

| `dataikuapi.fm.instances.FMInstanceEncryptionMode`(value) | An enumeration. |

| `dataikuapi.fm.instances.FMInstanceStatus`(data) | A class holding read-only information about an Instance. |

| `dataikuapi.fm.instances.FMSnapshot`(client, ...) | A handle to interact with a snapshot of a DSS instance. |
