# Govern Blueprint Designer[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-blueprint-designer.html#govern-blueprint-designer "Permalink to this heading")

The Blueprint Design is used to edit and customize blueprints and blueprint versions.

## Fork a Govern Project blueprint version[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-blueprint-designer.html#fork-a-govern-project-blueprint-version "Permalink to this heading")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # get the blueprint designer

§ blueprint\_designer = client.get\_blueprint\_designer()

§ # get the provided govern\_project blueprint

§ govern\_project\_bp = blueprint\_designer.get\_blueprint('bp.system.govern\_project')

§ # fork a blueprint version

§ govern\_project\_new\_version = govern\_project\_bp.create\_version('my\_new\_version', name='My New Version', origin\_version\_id='bv.system.default')

§ # add a field and save version

§ new\_ver\_def = govern\_project\_new\_version.get\_definition()

§ new\_ver\_def.get\_raw()['fieldDefinitions']['new\_field'] = {

§ "description": "my new beautiful text field",

§ "fieldType": "TEXT",

§ "label": "my new field",

§ "required": False,

§ "sourceType": "STORE"

§ }

§ new\_ver\_def.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-blueprint-designer.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintDesigner`(client) | Handle to interact with the blueprint designer Do not create this directly, use `get\_blueprint\_designer()` |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintListItem`(...) | An item in a list of blueprints. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprint`(...) | A handle to interact with a blueprint as an admin on the Govern instance. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintDefinition`(...) | The definition of a blueprint. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintVersionListItem`(...) | An item in a list of blueprint versions. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintVersion`(...) | A handle to interact with a blueprint version. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintVersionDefinition`(...) | The blueprint version definition. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminBlueprintVersionTrace`(...) | The trace of a blueprint version containing information about its lineage and its status. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminSignoffConfigurationListItem`(...) | An item in a list of sign-off configurations. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminSignoffConfiguration`(...) | A handle to interact with the sign-off configuration of a specific step of a workflow. |

| `dataikuapi.govern.admin\_blueprint\_designer.GovernAdminSignoffConfigurationDefinition`(...) | The definition of signoff configuration. |
