# Govern Artifact Search[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifact-search.html#govern-artifact-search "Permalink to this heading")

The artifact search handler is used to search among artifacts.

## Search for all the Govern Project artifacts[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifact-search.html#search-for-all-the-govern-project-artifacts "Permalink to this heading")

§ import dataikuapi

§ from dataikuapi.govern.artifact\_search import GovernArtifactSearchQuery, GovernArtifactFilterBlueprints

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # build a query

§ govern\_projects\_query = GovernArtifactSearchQuery(artifact\_filters=[GovernArtifactFilterBlueprints(blueprint\_ids=['bp.system.govern\_project'])])

§ # build a request

§ request = client.new\_artifact\_search\_request(govern\_projects\_query)

§ # perform the search (first batch)

§ result\_1 = request.fetch\_next\_batch()

§ # continue the search (next batch)...

§ result\_2 = request.fetch\_next\_batch()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifact-search.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchRequest`(...) | A search request object. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchResponse`(...) | A search request response for a single batch. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchResponseHit`(...) | A search request response. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchQuery`([...]) | A definition of an artifact query. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSource`(...) | An abstract class to represent the different search source. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSourceAll`() | A generic search source definition. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSort`(...) | An abstract class to represent the different search sort. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSortName`([...]) | An artifact sort definition based on their names. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSortWorkflow`([...]) | An artifact sort defintion based on their workflow. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSortField`([...]) | An artifact sort definition based on a list of fields. |

| `dataikuapi.govern.artifact\_search.GovernArtifactSearchSortFieldDefinition`(...) | A field sort definition builder to use in a search query in order to sort on a field of a blueprint. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilter`(...) | An abstract class to represent artifact filters. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilterBlueprints`([...]) | An artifact filter definition based on a list of specific blueprints. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilterBlueprintVersions`([...]) | An artifact filter definition based on a list of specific blueprint versions. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilterArtifacts`([...]) | An artifact filter definition based on a list of specific artifacts. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilterFieldValue`(...) | An artifact filter definition based on specific fields value. |

| `dataikuapi.govern.artifact\_search.GovernArtifactFilterArchivedStatus`(...) | An artifact filter definition based on the archived status. |
