# Users and groups[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#users-and-groups "Permalink to this heading")

The API exposes key parts of the Dataiku Govern access control management: users and groups. All these can be created, modified and deleted through the API.

## Example use cases[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#example-use-cases "Permalink to this heading")

In all examples, client is a `dataikuapi.govern\_client.GovernClient`, obtained using `dataikuapi.govern\_client.GovernClient.\_\_init\_\_()`

### Listing users[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#listing-users "Permalink to this heading")

§ client = GovernClient(host, apiKey)

§ govern\_users = client.list\_users()

§ # govern\_users is a list of dict. Each item represents one user

§ prettyprinter.pprint(govern\_users)

outputs

§ [   {   'displayName': 'Administrator',

§ 'groups': ['administrators', 'data\_scientists'],

§ 'login': 'admin',

§ 'sourceType': 'LOCAL'},

§ ...

§ ]

### Creating a user[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#creating-a-user "Permalink to this heading")

#### A local user with a password[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#a-local-user-with-a-password "Permalink to this heading")

§ new\_user = client.create\_user('test\_login', 'test\_password', display\_name='a test user', groups=['all\_powerful\_group'])

new\_user is a `dataikuapi.govern.admin.GovernUser`

#### A user who will login through LDAP[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#a-user-who-will-login-through-ldap "Permalink to this heading")

Note that it is not usually required to manually create users who will login through LDAP as they can be automatically provisionned

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LDAP", groups=['all\_powerful\_group'], profile="DESIGNER")

#### A user who will login through SSO[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#a-user-who-will-login-through-sso "Permalink to this heading")

This is only for non-LDAP users that thus will not be automatically provisioned, buut should still be able to log in through SSO.

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LOCAL\_NO\_AUTH", groups=['all\_powerful\_group'], profile="DESIGNER")

### Modifying a user’s display name, groups, profile, email, …[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#modifying-a-user-s-display-name-groups-profile-email "Permalink to this heading")

To modify the settings of a user, get a handle through `dataikuapi.govern\_client.GovernClient.get\_user()`, then use `dataikuapi.govern.admin.GovernUser.get\_settings()`

§ user = client.get\_user("theuserslogin")

§ settings = user.get\_settings()

§ # Modify the settings in the `get\_raw()` dict

§ settings.get\_raw()["displayName"] = "Govern Lover"

§ settings.get\_raw()["email"] = "my.new.email@stuff.com"

§ settings.get\_raw()["userProfile"] = "DESIGNER"

§ settings.get\_raw()["groups"] = ["group1", "group2", "group3"] # This completely overrides previous groups

§ # Save the modifications

§ settings.save()

### Deleting a user[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#deleting-a-user "Permalink to this heading")

§ user = client.get\_user('test\_login')

§ user.delete()

### Impersonating another user[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#impersonating-another-user "Permalink to this heading")

As a Dataiku Govern administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

### Listing groups[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#listing-groups "Permalink to this heading")

A list of the groups can by obtained with the list\_groups method:

§ client = GovernClient(host, apiKey)

§ # govern\_groups is a list of dict. Each group contains at least a "name" attribute

§ govern\_groups = client.list\_groups()

§ prettyprinter.pprint(govern\_groups)

outputs

§ [   {   'admin': True,

§ 'description': 'Govern administrators',

§ 'name': 'administrators',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-write access',

§ 'name': 'data\_scientists',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-only access',

§ 'name': 'readers',

§ 'sourceType': 'LOCAL'}]

### Creating a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#creating-a-group "Permalink to this heading")

§ new\_group = client.create\_group('test\_group', description='test group', source\_type='LOCAL')

### Modifying settings of a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#modifying-settings-of-a-group "Permalink to this heading")

First, retrieve the group definition with a get\_definition call, alter the definition, and set it back into Govern:

§ group\_definition = new\_group.get\_definition()

§ group\_definition['admin'] = True

§ group\_definition['ldapGroupNames'] = 'group1,group2'

§ new\_group.set\_definition(group\_definition)

### Deleting a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#deleting-a-group "Permalink to this heading")

§ group = client.get\_group('test\_group')

§ group.delete()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-users-groups.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.admin.GovernUser`(client, login) | A handle for a user on the Govern instance. |

| `dataikuapi.govern.admin.GovernUserSettings`(...) | Settings for a Govern user. |

| `dataikuapi.govern.admin.GovernOwnUser`(client) | A handle to interact with your own user Do not create this object directly, use `get\_own\_user()` instead. |

| `dataikuapi.govern.admin.GovernOwnUserSettings`(...) | Settings for the current Govern user. |

| `dataikuapi.govern.admin.GovernGroup`(client, name) | A group on the Govern instance. |
