# Managed folders[¶](https://developer.dataiku.com/latest/concepts-and-examples/managed-folders.html#managed-folders "Permalink to this heading")

Note

There are two main classes related to managed folder handling in Dataiku’s Python APIs:

* `dataiku.Folder` in the `dataiku` package. It was initially designed for usage within DSS in recipes and Jupyter notebooks.

* `dataikuapi.dss.managedfolder.DSSManagedFolder` in the `dataikuapi` package. It was initially designed for usage outside of DSS.

Both classes have fairly similar capabilities, but we recommend using `dataiku.Folder` within DSS.

For more details on the two packages, please see Getting started

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/managed-folders.html#detailed-examples "Permalink to this heading")

This section contains more advanced examples on Managed Folders.

### Load a model from a remote Managed Folder[¶](https://developer.dataiku.com/latest/concepts-and-examples/managed-folders.html#load-a-model-from-a-remote-managed-folder "Permalink to this heading")

If you have a trained model artifact stored remotely (e.g. using a cloud object storage Connection like AWS S3), then you can leverage it in a code Recipe. To do so, you first need to download the artifact and temporarily store it on the Dataiku instance’s local filesystem. The following code sample illustrates an example using a Tensorflow serialized model and assumes that it is stored in a Managed Folder called `spam\_detection` alog with the following files:

* `saved\_model.pb`

* `variables/variables.data-00000-of-00001`

* `variables/variables.index`

§ import dataiku

§ import tensorflow as tf

§ from tensorflow.keras.models import load\_model

§ import os

§ import tempfile

§ from pathlib import Path

§ import shutil

§ folder = dataiku.Folder("NvrBgKDk")

§ model\_folder = "spam\_detection"

§ #Create temporary directory in /tmp

§ with tempfile.TemporaryDirectory() as tmpdirname:

§ #Loop through every file of the TF model and copy it localy to the tmp directory

§ for file\_name in folder.list\_paths\_in\_partition():

§ local\_file\_path = tmpdirname + file\_name

§ #Create file localy

§ if not os.path.exists(os.path.dirname(local\_file\_path)):

§ os.makedirs(os.path.dirname(local\_file\_path))

§ #Copy file from remote to local

§ with folder.get\_download\_stream(file\_name) as f\_remote, open(local\_file\_path,'wb') as f\_local:

§ shutil.copyfileobj(f\_remote,f\_local)

§ #Load model from local repository

§ model = tf.keras.models.load\_model(os.path.join(tmpdirname,model\_folder))

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/managed-folders.html#reference-documentation "Permalink to this heading")

Use the following class to interact with managed folders in Python recipes and notebooks. For more information see Managed folders and Usage in Python for usage examples of the Folder API.

Use the following class preferably outside of DSS.

|  |  |

| --- | --- |

| `dataikuapi.dss.managedfolder` |  |
