# Meanings[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#meanings "Permalink to this heading")

The API offers methods to retrieve the list of meanings and their definition, to create a new meaning or update an existing one.

## Listing meanings[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#listing-meanings "Permalink to this heading")

The list of all user-defined meanings can be fetched with the `list\_meanings()` method of the `DSSClient`.

§ client.list\_meanings()

## Creating a meaning[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#creating-a-meaning "Permalink to this heading")

The `dataikuapi.dssclient.DSSClient.create\_meaning()` method can be used to create new meanings.

§ # Creating a declarative meaning

§ client.create\_meaning("meaning\_1", "Test meaning", "DECLARATIVE",

§ description="Test meaning description"

§ )

§ # Creating a value list meaning

§ client.create\_meaning("meaning\_2", "Test meaning", "VALUES\_LIST",

§ description="Test meaning",

§ values=["mercury","venus","earth","mars","jupiter","saturn","uranus","neptune"],

§ normalizationMode="LOWERCASE"

§ )

§ # Creating a value mapping meaning

§ client.create\_meaning("meaning\_3", "Test meaning", "VALUES\_MAPPING",

§ mappings=[

§ {"from": "0", "to": "no"   },

§ {"from": "1", "to": "yes"  },

§ {"from": "2", "to": "maybe"}

§ ]

§ )

§ # Creating a pattern meaning

§ client.create\_meaning("meaning\_4", "Test meaning", "PATTERN", pattern="[A-Z]+")

## Editing a meaning[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#editing-a-meaning "Permalink to this heading")

Existing meanings can be fetched by calling the `dataikuapi.dssclient.DSSClient.get\_meaning()` method with the meaning ID. It returns a meaning handle that can be used to get or set the meaning’s definition with `get\_definition()` and `set\_definition()`, as follows:

§ meaning = client.get\_meaning("meaning\_1")

§ definition = meaning.get\_definition()

§ definition['label'] = "New label"

§ definition['description'] = "New description"

§ meaning.set\_definition(definition)

## Assigning a meaning to a column[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#assigning-a-meaning-to-a-column "Permalink to this heading")

Meanings can be assigned to columns by editing the schema of their dataset and setting the ‘meaning’ field of the column to the ID of the desired meaning.

§ dataset = client.get\_project("TEST\_PROJECT").get\_dataset("TEST\_DATASET")

§ schema = dataset.get\_schema()

§ schema['columns'][2]['meaning'] = "meaning\_1"

§ dataset.set\_schema(schema)

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/meanings.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.meaning.DSSMeaning`(client, id) | A user-defined meaning on the DSS instance |
